"""
$Id: toolbox.py,v 1.3 2005/09/28 14:35:41 clebeaupin Exp $
"""

__author__  = ''
__docformat__ = 'restructuredtext'

# Python imports
from StringIO import StringIO

# CMF imports
from Products.CMFCore.utils import getToolByName

# Products imports
from Products.PloneArticle.migration.Migrator import change_text_mimetype

def unindex_plonearticle_contents(self, portal_types=None):
    """Unindex contents in PloneArticle"""
    out = StringIO()
    cat_tool = getToolByName(self, 'portal_catalog')
    
    if portal_types is None:
        portal_types = 'PloneArticle'
    
    article_brains = cat_tool(portal_type=portal_types)
    
    for article_brain in article_brains:
        article = article_brain.getObject()
        
        for obj in article.objectValues():
            # Add acquisitions on all permissions
            permissions = [x[0] for x in obj.ac_inherited_permissions(1)]
            obj.manage_acquiredPermissions(permissions)
            # Unindex content
            cat_tool.unindexObject(obj)
        
    out.write('Catalog rebuilt.\n')
    return out.getvalue()