# Copyright (c) 2003-2006 Ingeniweb SAS

# This software is subject to the provisions of the GNU General Public
# License, Version 2.0 (GPL).  A copy of the GPL should accompany this
# distribution.  THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL
# EXPRESS OR IMPLIED WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY,
# AGAINST INFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE

# More details in the ``LICENSE`` file included in this package.

"""
$Id: toolbox.py,v 1.6 2006/07/20 10:01:38 glenfant Exp $
"""

__author__  = ''
__docformat__ = 'restructuredtext'

# Python imports
from StringIO import StringIO

# CMF imports
from Products.CMFCore.utils import getToolByName

# Products imports
from Products.PloneArticle.migration.Migrator import change_text_mimetype

def unindex_plonearticle_contents(self, portal_types=None):
    """Unindex contents in PloneArticle"""
    out = StringIO()
    cat_tool = getToolByName(self, 'portal_catalog')
    
    if portal_types is None:
        portal_types = 'PloneArticle'
    
    article_brains = cat_tool(portal_type=portal_types)
    
    for article_brain in article_brains:
        article = article_brain.getObject()
        
        for obj in article.objectValues():
            # Add acquisitions on all permissions
            permissions = [x[0] for x in obj.ac_inherited_permissions(1)]
            obj.manage_acquiredPermissions(permissions)
            # Unindex content
            cat_tool.unindexObject(obj)
        
    out.write('Catalog rebuilt.\n')
    return out.getvalue()
