# Copyright (c) 2003-2006 Ingeniweb SAS

# This software is subject to the provisions of the GNU General Public
# License, Version 2.0 (GPL).  A copy of the GPL should accompany this
# distribution.  THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL
# EXPRESS OR IMPLIED WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY,
# AGAINST INFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE

# More details in the ``LICENSE`` file included in this package.

"""
$Id: toolbox.py,v 1.8 2006/08/11 21:09:30 glenfant Exp $
"""

__author__  = ''
__docformat__ = 'restructuredtext'

# Python imports
from StringIO import StringIO

# CMF imports
from Products.CMFCore.utils import getToolByName

# Products imports
from Products.PloneArticle.PloneArticle import PloneArticle
from Products.PloneArticle.migration.Migrator import change_text_mimetype

def unindex_plonearticle_contents(self, portal_types=None):
    """Unindex contents in PloneArticle"""
    out = StringIO()
    cat_tool = getToolByName(self, 'portal_catalog')
    
    if portal_types is None:
        pa_meta_types = paBasedMetaTypes(self)
        article_brains = portal_catalog(meta_type=pa_meta_types)
    else:
        article_brains = cat_tool(portal_type=portal_types)

    count = 0
    for article_brain in article_brains:
        article = article_brain.getObject()
        
        for obj in article.objectValues():
            count += 1
            # Add acquisitions on all permissions
            permissions = [x[0] for x in obj.ac_inherited_permissions(1)]
            obj.manage_acquiredPermissions(permissions)
            # Unindex content
            cat_tool.unindexObject(obj)

    print >> out, "%d PloneArticle subobjects have been removed from portal_catalog\n" % count
    return out.getvalue()

def fixAttachmentsSecurity(self):
    """Fix security matrix for all included attachments and images The
    "update security settings" from portal_workflow breaks the
    PloneArticle specific policy."""

    out = StringIO()
    portal_catalog = getToolByName(self, 'portal_catalog')

    # Finding  PloneArticle based types
    pa_meta_types = paBasedMetaTypes(self)
    article_brains = portal_catalog(meta_type=pa_meta_types)

    # Let's fix the security
    count = 0
    for brain in article_brains:
        article = brain.getObject()
        if article is None:
            # Eeek: ghost object
            continue
        count += 1
        atts = article.objectValues()
        for att in atts:
            permissions = att.permission_settings()
            permissions = [p['name'] for p in att.permission_settings()]
            for permission in permissions:
                att.manage_permission(permission, acquire=1)
    print >> out, "Security fixed for %d PloneArticle content attachments\n" % count
    return out.getvalue()

def paBasedMetaTypes(self):
    """Meta-types of all PA based types"""

    portal_types = getToolByName(self, 'portal_types')
    archetype_tool = getToolByName(self, 'archetype_tool')

    # Finding  PloneArticle based types
    factory_meta_type = 'Factory-based Type Information'
    all_meta_types = [factory.Metatype()
                      for factory in portal_types.objectValues(spec=factory_meta_type)]
    at_registered = archetype_tool.listRegisteredTypes()
    pa_meta_types = [t['meta_type'] for t in at_registered
                     if (issubclass(t['klass'], PloneArticle)
                         and
                         t['meta_type'] in all_meta_types)]
    return pa_meta_types
