from Products.PloneFormGen.config import \
    PROJECTNAME, GLOBALS, fieldTypes, adapterTypes, thanksTypes
from Products.CMFCore.utils import getToolByName
from Products.CMFPlone.utils import safe_hasattr
from Products.Archetypes.public import listTypes
from Products.Archetypes.Extensions.utils import installTypes, install_subskin
from StringIO import StringIO


allTypes = ('FormFolder',) + fieldTypes + adapterTypes + thanksTypes

def install(self):
    out = StringIO()

    print >> out, "Installing PloneFormGen"

    # Install types
    classes = listTypes(PROJECTNAME)
    installTypes(self, out,
                 classes,
                 PROJECTNAME)
    print >> out, "Installed types"

    ## Install skin
    install_subskin(self, out, GLOBALS)
    print >> out, "Installed skin"

    # Enable portal_factory
    factory = getToolByName(self, 'portal_factory')
    types = factory.getFactoryTypes().keys()
    for f in allTypes:
        if f not in types:
            types.append(f)
    factory.manage_setPortalFactoryTypes(listOfTypeIds = types)
    print >> out, "Added all my types to portal_factory"

    propsTool = getToolByName(self, 'portal_properties')
    siteProperties = getattr(propsTool, 'site_properties')
    navtreeProperties = getattr(propsTool, 'navtree_properties')

    # Add the field, thanks and adapter types to types_not_searched
    typesNotSearched = list(siteProperties.getProperty('types_not_searched'))
    for f in fieldTypes + adapterTypes + thanksTypes:
        if f not in typesNotSearched:
            typesNotSearched.append(f)
    siteProperties.manage_changeProperties(types_not_searched = typesNotSearched)
    print >> out, "Added form fields & adapters to types_not_searched"

    # Add the field, thanks and adapter types to types excluded from navigation
    typesNotListed = list(navtreeProperties.getProperty('metaTypesNotToList'))
    for f in fieldTypes + adapterTypes + thanksTypes:
        if f not in typesNotListed:
            typesNotListed.append(f)
    navtreeProperties.manage_changeProperties(metaTypesNotToList = typesNotListed)
    print >> out, "Added form fields & adapters to metaTypesNotToList"

    # Set up the workflow for the field, thanks and adapter types: there should be none!
    wft = getToolByName(self, 'portal_workflow')
    wft.setChainForPortalTypes(fieldTypes + adapterTypes + thanksTypes, ())
    print >> out, "Set up empty field and adapter workflows."

    # Add FormFolder to kupu's linkable types
    kupuTool = getToolByName(self, 'kupu_library_tool')
    linkable = list(kupuTool.getPortalTypesForResourceType('linkable'))
    if 'FormFolder' not in linkable:
        linkable.append('FormFolder')
    # See optilude's note in the RichDocument install re why this is so odd.
    kupuTool.updateResourceTypes(({'resource_type' : 'linkable',
                                   'old_type'      : 'linkable',
                                   'portal_types'  :  linkable},))
    print >> out, "Added FormFolder to kupu's linkable types"


    if not safe_hasattr(self, 'formgen_tool'):
        addTool = self.manage_addProduct['PloneFormGen'].manage_addTool
        addTool('PloneFormGen Tool')
    print >> out, "Added PloneFormGen Tool"


    ##
    ## Print install info
    ##
    print >> out, "Successfully installed %s." % PROJECTNAME
    return out.getvalue()


def uninstall_tool(self, out):
    try:
        self.manage_delObjects(['formgen_tool'])
    except:
        pass
    else:
        print >>out, "PloneFormGen tool removed"


def uninstall(self):
    out = StringIO()

    uninstall_tool(self, out)

    # remove FormFolder from kupu's linkable types
    kupuTool = getToolByName(self, 'kupu_library_tool')
    linkable = list(kupuTool.getPortalTypesForResourceType('linkable'))
    if 'FormFolder' in linkable:
        linkable.remove('FormFolder')
    kupuTool.updateResourceTypes(({'resource_type' : 'linkable',
                                   'old_type'      : 'linkable',
                                   'portal_types'  :  linkable},))
    print >> out, "Removed FormFolder from kupu's linkable types"


    propsTool = getToolByName(self, 'portal_properties')
    siteProperties = getattr(propsTool, 'site_properties')
    navtreeProperties = getattr(propsTool, 'navtree_properties')

    # remove the field, thanks and adapter types from types excluded from navigation
    typesNotListed = list(navtreeProperties.getProperty('metaTypesNotToList'))
    for f in fieldTypes + adapterTypes + thanksTypes:
        if f in typesNotListed:
            typesNotListed.remove(f)
    navtreeProperties.manage_changeProperties(metaTypesNotToList = typesNotListed)
    print >> out, "Removed form fields & adapters from metaTypesNotToList"

    # Remove the field, thanks and adapter types from types_not_searched
    typesNotSearched = list(siteProperties.getProperty('types_not_searched'))
    for f in fieldTypes + adapterTypes + thanksTypes:
        if f in typesNotSearched:
            typesNotSearched.remove(f)
    siteProperties.manage_changeProperties(types_not_searched = typesNotSearched)
    print >> out, "Removed form fields & adapters from types_not_searched"

    # XXX
    # I'd love to uninstall the subskin, too. If anyone knows how, please
    # drop me a note.


    print >> out, "Successfully uninstalled %s." % PROJECTNAME
    return out.getvalue()
