#
# Test PloneFormGen initialisation and set-up
#

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Products.PloneFormGen.tests import pfgtc

from Products.CMFCore.utils import getToolByName

class FakeRequest(dict):
    
    def __init__(self, **kwargs):
        self.form = kwargs

class TestFunctions(pfgtc.PloneFormGenTestCase):
    """ test top-level functionality """
    
    def dummy_send( self, mfrom, mto, messageText ):
        self.mfrom = mfrom
        self.mto = mto
        self.messageText = messageText


    def afterSetUp(self):
        pfgtc.PloneFormGenTestCase.afterSetUp(self)
        self.folder.invokeFactory('FormFolder', 'ff1')
        self.ff1 = getattr(self.folder, 'ff1')
        self.mailhost = self.folder.MailHost
        self.mailhost._send = self.dummy_send        
        self.ff1.mailer.setRecipient_email('mdummy@address.com')
        

    def testFgFieldsDisplayList(self):
        """ test Form Folder's fgFieldsDisplayList """

        # in v 1.0.2, this caused "'unicode' object has no attribute 'decode'" w/ Plone 2.5.1 and Zope 2.8.7
        res = self.ff1.fgFieldsDisplayList()
        
        self.assertEqual(len(res), 3)
        self.assertEqual( res.keys()[0], 'replyto' )
        self.failUnless( isinstance(res.values()[0], unicode) )
        

    def test_DummyMailer(self):
        """ sanity check; make sure dummy mailer works as expected """

        self.mailhost.send('messageText', mto='dummy@address.com', mfrom='dummy1@address.com')
        self.failUnless( self.messageText.endswith('messageText') )
        self.assertEqual(self.mto, ['dummy@address.com'])
        self.failUnless( self.messageText.find('To: dummy@address.com') > 0 )
        self.assertEqual(self.mfrom,'dummy1@address.com')
        self.failUnless( self.messageText.find('From: dummy1@address.com') > 0 )
        # print "|%s" % self.messageText


    def test_Mailer(self):
        """ Test mailer with dummy_send """
    
    
        mailer = self.ff1.mailer
        
        fields = self.ff1._getFieldObjects()
        
        request = FakeRequest(topic = 'test subject')
        
        mailer.onSuccess(fields, request)
        
        self.failUnless( self.messageText.find('To: <mdummy@address.com>') > 0 )
        self.failUnless( self.messageText.find('Subject: =?utf-8?q?test_subject?=') > 0 )        
        
        # print "|%s" % self.messageText


    def test_Validate(self):
        """ Test required field validation """

        request = FakeRequest(topic = 'test subject')
        
        errors = self.ff1.fgvalidate(REQUEST=request)
        self.failUnless( errors['replyto'] )
        self.failUnless( errors['comments'] )
        self.failUnless( errors.get('topic') is None )
        
        request = FakeRequest(topic = 'test subject', replyto='testtest.org', comments='test comments')
        errors = self.ff1.fgvalidate(REQUEST=request)
        self.failUnless( errors['replyto'] )

        request = FakeRequest(topic = 'test subject', replyto='test@test.org', comments='test comments')
        errors = self.ff1.fgvalidate(REQUEST=request)
        self.assertEqual( errors, {} )

        # since that should have validated, it should have been mailed
        self.failUnless( self.messageText.find('Reply-To: test@test.org') > 0 )

    
    def testSaver(self):
        """ test save data adapter action """

        self.ff1.invokeFactory('FormSaveDataAdapter', 'saver')

        self.failUnless('saver' in self.ff1.objectIds())
        saver = self.ff1.saver
        
        self.ff1.setActionAdapter( ('saver',) )
        self.assertEqual(self.ff1.actionAdapter, ('saver',))

        # print "|%s|" % saver.SavedFormInput
        self.assertEqual(saver.itemsSaved(), 0)

        res = saver.getSavedFormInputForEdit()
        self.assertEqual(res, '')

        request = FakeRequest(topic = 'test subject', replyto='test@test.org', comments='test comments')
        errors = self.ff1.fgvalidate(REQUEST=request)
        self.assertEqual( errors, {} )
        
        self.assertEqual(saver.itemsSaved(), 1)

        res = saver.getSavedFormInputForEdit()
        self.assertEqual(res.strip(), 'test@test.org,test subject,test comments')


    def testMissingAdapter(self):
        """ test response to missing adapter -- should not fail """

        self.ff1.invokeFactory('FormSaveDataAdapter', 'saver')

        self.ff1.setActionAdapter( ('bogus',) )
        self.assertEqual(self.ff1.actionAdapter, ('bogus',))

        request = FakeRequest(topic = 'test subject', replyto='test@test.org', comments='test comments')
        errors = self.ff1.fgvalidate(REQUEST=request)
        self.assertEqual( errors, {} )


if  __name__ == '__main__':
    framework()

def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    suite.addTest(makeSuite(TestFunctions))
    return suite
