""" FormGenTool manages site-wide PloneFormGen settings """ 

__author__  = 'Steve McMahon <steve@dcn.org>'
__docformat__ = 'plaintext'

from AccessControl import ClassSecurityInfo
from OFS.PropertyManager import PropertyManager
from OFS.SimpleItem import SimpleItem 

from Products.CMFCore.permissions import View, ManagePortal
from Products.CMFCore.utils import UniqueObject 
from Globals import InitializeClass 

from Products.PloneFormGen import config

class FormGenTool(UniqueObject, SimpleItem): 
    """ FormGenTool manages site-wide PloneFormGen settings """ 

    id = 'formgen_tool'
    meta_type= 'PloneFormGen Tool' 
    title = 'PloneFormGen Settings'
    plone_tool = True
    security = ClassSecurityInfo()
    

    def __init__(self):
        pass
        
    security.declareProtected(View, 'getdefaultMailTemplateBody')
    def getdefaultMailTemplateBody(self):
        """ get the site's default mail adapter mail body template """
        
        return getattr(self, 'defaultMailTemplateBody', config.DEFAULT_MAILTEMPLATE_BODY)


    security.declareProtected(ManagePortal, 'setdefaultMailTemplateBody')
    def setdefaultMailTemplateBody(self, value):
        """ sets the site's default mail adapter mail body template """
        
        self.defaultMailTemplateBody = value


InitializeClass(FormGenTool) 