# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Author: Nik Kim <fafhrd@legco.biz> 
__version__ = '$Revision: 1.6 $'[11:-2]

import os, sys, time, traceback

import smtplib
from zLOG import LOG, INFO, ERROR
from Acquisition import aq_base, aq_parent, aq_inner
from Globals import InitializeClass
from AccessControl import ClassSecurityInfo
from AccessControl.Permission import Permission
from OFS.SimpleItem import SimpleItem
from Products.CMFCore.utils import UniqueObject, getToolByName, _checkPermission

from debug import log, log_exc

class MailSpool(UniqueObject, SimpleItem):
    """ """
    meta_type = 'PortalTransport Mail Spool'

    security = ClassSecurityInfo()
    
    _registered=None

    id = 'portal_mailspool'

    def __getstate__(self):
        data = MailSpool.inheritedAttribute('__getstate__')(self)

        try:
            del data['_registered']
        except:
            pass

        try:
            del data['_messages']
        except:
            pass

        return data
        
    security.declarePrivate('sendmail')
    def sendmail(self, from_addr, to_addrs, msg):
        if not self._registered:
            try:
                get_transaction().register(Surrogate(self))
                self._registered = 1
                self._finalize = 0
                self._messages = []
            except:
                pass
            
        self._messages.append((from_addr, to_addrs, msg))

    def tpc_begin(self, *ignored):
        pass

    def commit(self, *ignored):
        portal = aq_parent(aq_inner(self))
        try:
            mailer = portal.portal_properties.portaltransport_properties.mailer
        except:
            mailer = 'PortalTransport MailTransport'

        try:
            mh = portal.MailHost
            smtp = smtplib.SMTP(mh.smtp_host, int(mh.smtp_port))

            for from_addr, to_addrs, msg in self._messages:
                if not msg.has_key('X-Mailer'):
                    msg['X-Mailer'] = mailer
                smtp.sendmail(from_addr, to_addrs, msg.as_string())
            
            smtp.quit()
        except Exception, e:
            log_exc('MailSpool Error:%s'%e, level=ERROR)


    def tpc_vote(self, *ignored):
        self._finalize = 1

    def tpc_finish(self, *ignored):
        self._registered=0

    def abort(self, *ignored):
        self._messages = []
        self._registered=0

    def tpc_abort(self, *ignored):
        pass

    def sortKey(self):
        return id(self)

InitializeClass(MailSpool)



class Surrogate:
    def __init__(self, obj):
        self._p_jar = obj
        self._p_oid = obj
        self.__inform_commit__=obj.tpc_finish
        self.__inform_abort__=obj.tpc_abort
