# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Authors: Nik Kim <fafhrd@legco.biz>

import re, traceback
from Globals import InitializeClass
from AccessControl import ClassSecurityInfo
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.CMFCorePermissions import View, ModifyPortalContent, ManagePortal
from Products.CMFCore.WorkflowCore import ObjectDeleted

from interfaces.subscribeable import IMemberSubscribeable
from SubscribeableBase import BaseSubscribeable
from PortalTransportPermissions import *


siType = 'PT_SIMember'

class SubscribeableMember(BaseSubscribeable):
    """ """

    __implements__ = BaseSubscribeable.__implements__ + (IMemberSubscribeable,)

    security = ClassSecurityInfo()

    security.declareProtected(View, 'isSubscribed')
    def isSubscribed(self, user_id=None):
        """ """
        mtool = getToolByName(self, 'portal_membership')
        if mtool.isAnonymousUser():
            return 0
        else:
            subs = getToolByName(self, 'portal_subscriptions')
            member = mtool.getAuthenticatedMember()
            return subs.isSubscribed(self, member_id=member.getMemberId())

    security.declareProtected(AllowSubscription, 'isAutoActivateSubscription')
    def isAutoActivateSubscription(self):
	""" auto activate or start activate process """
        return 1

    security.declareProtected(ManagePortal, 'addSubscribers')
    def addSubscribers(self, members, hint=''):
        """ """
        subs = getToolByName(self, 'portal_subscriptions')
        subs.addSubscriptions(members, self, hint=hint)

    security.declareProtected(AllowSubscription, 'subscribe')
    def subscribe(self, text_format='plain', hint=''):
        """ """
        mtool = getToolByName(self, 'portal_membership')
        if mtool.isAnonymousUser():
            raise Exception, "Can't subscribe Anonymous User."


        member = mtool.getAuthenticatedMember()
        # Check if user is a portal member
        if mtool.getMemberById(member.getId()) is None:
           raise Exception, "Can only subscribe portal member."

        subs = getToolByName(self, 'portal_subscriptions')
        
        if not subs.isSubscribed(self, member_id=member.getMemberId()):
            subs.addSubscriptions(siType, ({'member': member, 'content': self,
                                            'hint': hint, 'text_format': text_format},) )
        else:
            raise Exception, 'You already subscribed.'

    security.declareProtected(AllowSubscription, 'unsubscribe')
    def unsubscribe(self):
        """ """
        portal = getToolByName(self, 'portal_url').getPortalObject()
        
        mtool = portal.portal_membership
        if mtool.isAnonymousUser():
            raise Exception, "Can't unsubscribe Anonymous User."

        subs = portal.portal_subscriptions
        wtool = portal.portal_workflow
        
        member = mtool.getAuthenticatedMember()

        subs = subs.getSubscriptions(self, member_id=member.getMemberId())
        if subs:
            for si in subs:
                try:
                    si.wm_deactivate()
                except ObjectDeleted:
                    pass
        else:
            raise Exception, 'You are not subscribed.'


InitializeClass(SubscribeableMember)
