# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Authors: Nik Kim <fafhrd@legco.biz> 
__version__ = '$Revision: 1.21 $'[11:-2]

import traceback, zLOG
from DateTime import DateTime
from Globals import InitializeClass
from Acquisition import aq_base, aq_inner, aq_parent

from AccessControl import ClassSecurityInfo
from AccessControl.SecurityManagement import getSecurityManager, \
     newSecurityManager, noSecurityManager
from AccessControl.SimpleObjectPolicies import _noroles
from AccessControl.Permission import Permission

from Products.ZCatalog.ZCatalog import ZCatalog
from Products.BTreeFolder2.BTreeFolder2 import BTreeFolder2
from Products.CMFCore.utils import getToolByName, SimpleItemWithProperties
from Products.CMFCore.WorkflowCore import ObjectDeleted
from Products.CMFCore.CMFCorePermissions import View, ManagePortal

from Products.Archetypes.config import TOOL_NAME
from Products.Archetypes.interfaces.referenceable import IReferenceable

from email.Utils import formataddr

from config import *
from utils import make_uuid

indexes = (('UID', 'FieldIndex'),
           ('member_id', 'FieldIndex'),
           ('email', 'FieldIndex'),
           ('content_uid', 'FieldIndex'),
           ('modified', 'DateIndex'),
           ('review_state', 'FieldIndex'),
           ('portal_type', 'FieldIndex'),
	   ('hint', 'FieldIndex'),
           ('Type', 'FieldIndex'),
           ('allowedRolesAndUsers', 'KeywordIndex'),
           )

class AllowAllSandbox:
    def validate(self, accessed, container, name, value, context, roles=_noroles):
        return 1


class SubscriptionEngine(BTreeFolder2, ZCatalog):
    """ class for manage single subscription """
    meta_type = PROJECTNAME + ' Subscriptions Tool'

    security = ClassSecurityInfo()

    manage_options = ZCatalog.manage_options

    def __init__(self, id):
        BTreeFolder2.__init__(self, id)
        ZCatalog.__init__(self, id)

        for idx_name, idx_type in indexes:
            self.addIndex(idx_name, idx_type)

    security.declareProtected(ManagePortal, 'getSubscriptions')
    def getSubscriptions(self, content=None, **kw):
        """ """
        infos = {}
        if content is not None:
            kw['content_uid'] = content.UID()

        for brain in self.searchResults(**kw):
            o = brain.getObject()
            if o is not None:
                infos[o.id] = o

        return infos.values()

    security.declareProtected(ManagePortal, 'removeSubscriptions')
    def removeSubscriptions(self, ids, noemail=0):
        """ """
        for id in ids:
            if noemail:
                try:
                    self._delObject(id)
                except:
                    pass
            else:
                try:
                    self._getOb(id).wm_deactivate()
                except ObjectDeleted:
                    pass

    security.declareProtected(ManagePortal, 'addSubscriptions')
    def addSubscriptions(self, siType, args):
        """ """
        try:
            self._removeExpired()
        except:
            traceback.print_exc()

        secman = getSecurityManager()
        old_policy = secman._policy

        secman._policy = AllowAllSandbox()

        ttool = aq_parent(aq_inner(self)).portal_types

        tp = ttool.getTypeInfo(siType)
        m = getattr(self.manage_addProduct[tp.product], tp.factory)

        for kw in args:
            uid = make_uuid()
            oid = 'si_%s'%uid
            kw['uid'] = uid

            id = apply(m, (oid,), kw)
            msg = tp._finishConstruction(self._getOb(id))

        secman._policy = old_policy


    security.declarePrivate('isSubscribed')
    def isSubscribed(self, content, **kw):
        """ """
        res = self.searchResults(content_uid=content.UID(), **kw)
        if res:
            return 1
        else:
            return 0

    def _removeExpired(self):
        """ remove expired not active subcriptions """
        date = DateTime() - 1
        for brain in self.searchResults(
            review_state='activation', modified={'query':(date,), 'range':'max'},):
            info = brain.getObject()
            if info is not None:
                info.wm_deactivate()

InitializeClass(SubscriptionEngine)
