# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# * Copyright (C) 2003 Nikolay Kim <fafhrd@legco.biz> 

from interface import Interface

class IBaseSubscribeable(Interface):

    def getEmailAddress():
        """ return email address of this content """

    def getSubscribers(hint):
        """ subscribers list, for manager """

    def addSubscribers(members, text_format, hint):
        """ add subscribers, for manager """

    def removeSubscribers(members):
        """ remove subscribers, for manager """

    def isSendSubscriptionNotifications():
        """ """

    def sendMessage(content, parent):
        """ send message to subscribers """


class IMemberSubscribeable(Interface):
    """ object can receive mails """

    def isSubscribed(user_id=None):
        """ check is subscribed current member or user_id """

    def isAutoActivateSubscription():
	""" auto activate or start activate process """

    def addSubscribers(members, hint=''):
        """ """

    def subscribe(text_format, hint):
        """ sunscribe current member to content """

    def unsubscribe():
        """ unsunscribe current member from content """


class IAnonymousSubscribeable(Interface):
    """ """

    def isAnonymousSubscribed(fullname, email):
        """ check is subscribed """

    def isAutoActivateAnonymousSubscription():
	""" auto activate or start activate process """

    def subscribeAnonymous(email, fullname, text_format, hint):
        """ subscribe anonymous user """

    def unsubscribeAnonymous(email):
        """ """
