def calculateDumbDown(self, property, node):
    rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
    rdfs="http://www.w3.org/1999/02/22-rdf-schema-ns#"
    dc="http://purl.org/dc/elements/1.1/"
    dct="http://purl.org/dc/terms/"
    dcq=dct	#	old: "http://purl.org/dc/qualifiers/1.0/"
    # care about cycles:
    if visitedHash==None:
        visitedHash={}
	#
    if node.is_literal():
        return node
    else:
        if property == (dc + "identifier")\
           or property == (dc + "reference")\
           or property == (dc + "source"):
            # preferably calculate a URI
            # Bag or Seq ?:
            if isinstance(node, rdf + "Bag") or 
               isinstance(node, rdf + "Seq"):
                return self.processBag_Seq(property,node,visitedHash)
			 
            # Alt ?
            if isinstance(node, rdf+"Alt"):
                return self._processAlt(property,node,visitedHash)
			
            # URI ? 
            if(node.getLabel != ""):
                return (node.getLabel)
			
            # rdfs:label ?
            label=node.getChildsByProperty(rdfs+"label")
            if label:
                return map _.getLabel label
			
            # has rdf:value?
            rdfvalue=node.getChildsByProperty(rdf+"value")
            if rdfvalue:
                return self._process_rdf_value(property,visitedHash,rdfvalue)
			
            # else: do nothing!
            return None
        else: 
            # rdfs:label ?
            label=node.getChildsByProperty(rdfs+"label")
            if label:
                return map _.getLabel label
			
            # has rdf:value?
            rdfvalue=node.getChildsByProperty(rdf+"value")
            if rdfvalue:
                return self._process_rdf_value(property,visitedHash,rdfvalue)
			
            # Bag or Seq ?:
            if isinstance(node, rdf+"Bag") or\
               isinstance(node, rdf+"Seq"):
                return self._processBag_Seq(property,node,visitedHash)
			 
            # Alt ?
            if isinstance(node, rdf+"Alt"):
                return self._processAlt(property,node,visitedHash)
			
            # has dc:title?
            title=node.getChildsByProperty(dc+"title")
            if title:
                return self._process_rdf_value(property,visitedHash,title)
			
            # URI ? 
            if(node.getLabel != ""):
                return (node.getLabel)
            
            # else: do nothing!
            return None
		
def _processBag_Seq (self,property,node,visitedHash):
    elements=node.rdfPath('element()')
    res=""
    for each elem(elements):
        res += (elem.getLabel + ";")
        if isinstance(elem, 'Literal')
        if isinstance(elem, 'Resource'):
            res=res.join(' ',self._calculateDumbDown(property,elem,visitedHash))		
    res=~s/\\s//
    return (res)

def _processAlt (self,property,node,visitedHash):
    elements = node.rdfPath('element()')
    erg = None
    for each elem(elements):
        push erg,elem.getLabel
        if isinstance(elem, 'Literal')
        if isinstance(elem, 'Resource'):
            push erg,self._calculateDumbDown(property,elem,visitedHash)		
    return erg	

def _process_rdf_value (self,property,visitedHash,rdfvalue):
    erg = None
    for each elem(rdfvalue):
        push erg,elem.getLabel
        if isinstance(elem, 'Literal')
        if isinstance(elem, 'Resource'):
            push erg,self._calculateDumbDown(property,elem,visitedHash)
    return erg
