
from Products.ReplaceSupport.ReplaceHandler import ReplaceHandler

__handler_class_name__ = 'HTMLDocumentHandler'

class HTMLDocumentHandler( ReplaceHandler ):
	'''search & replace in HTML Documents'''

	def getMetaType( self ):
		return 'HTML Document'
	
	def getChangePermission( self ):
		# HTML Documents do not have a change permission...
		return 'Add HTML Documents'

	def getBody( self, ob ):
		return ob.raw
	
	def manageEdit( self, ob, body, params='' ):
		ob.manage_edit( body )

