#
# Example ZopeTestCase testing web access to a freshly started ZServer.
#
# Note that we need to set up the error_log before starting the ZServer.
#
# Note further that the test thread needs to explicitly commit its
# transactions, so the ZServer thread(s) can see modifications made to
# the ZODB.
#
# IF YOU THINK YOU NEED THE WEBSERVER STARTED YOU ARE PROBABLY WRONG!
# This is only required in very special cases like when testing
# ZopeXMLMethods where XSLT processing is done by external tools that
# need to URL-call back into the Zope server.
#

# $Id: testWebserver.py,v 1.6 2003/11/01 18:48:18 shh42 Exp $

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

#os.environ['STUPID_LOG_FILE'] = os.path.join(os.getcwd(), 'zLOG.log')
#os.environ['STUPID_LOG_SEVERITY'] = '0'

from Testing import ZopeTestCase

from AccessControl import Unauthorized

# Create the error_log object
app = ZopeTestCase.app()
ZopeTestCase.utils.setupSiteErrorLog(app)
ZopeTestCase.close(app)

# Start the web server
host, port = ZopeTestCase.utils.startZServer(4)
base = 'http://%s:%d/%s' %(host, port, ZopeTestCase.folder_name)


import urllib

class ManagementOpener(urllib.FancyURLopener):
    def prompt_user_passwd(self, host, realm):
        return ('manager', 'secret')

class UnauthorizedOpener(urllib.FancyURLopener):
    def prompt_user_passwd(self, host, realm):
        raise Unauthorized, 'The URLopener was asked for authentication'


class TestWebserver(ZopeTestCase.ZopeTestCase):

    def afterSetUp(self):
        self.folder.acl_users._doAddUser('manager', 'secret', ['Manager'], [])
        self.folder.addDTMLMethod('index_html', file='index_html: <dtml-var objectIds>')
        self.folder.addDTMLMethod('secret_html', file='secret_html: <dtml-var objectIds>')
        # Lock down secret_html
        s = self.folder.secret_html
        for p in ZopeTestCase.standard_permissions:
            s.manage_permission(p, ['Manager'], acquire=0)
        # Need to commit so the ZServer threads see what we've done
        get_transaction().commit()

    def beforeClose(self):
        # Commit after cleanup
        get_transaction().commit()

    def testAccess(self):
        # Test access
        page = self.folder.index_html(self.folder)

    def testWeb(self):
        # Test web access
        urllib._urlopener = UnauthorizedOpener()
        page = urllib.urlopen(base+'/index_html').read()
        if page.find('Resource not found') >= 0:
            self.fail('Resource not found')

    def testWeb2(self):
        # Test web access to protected resource
        urllib._urlopener = ManagementOpener()
        page = urllib.urlopen(base+'/secret_html').read()
        if page.find('Resource not found') >= 0:
            self.fail('Resource not found')

    def testSecurity(self):
        # Test security of public resource
        # Should be accessible
        try: self.folder.restrictedTraverse('index_html')
        except Unauthorized: self.fail('Unauthorized')

    def testSecurity2(self):
        # Test security of protected resource
        # Should be protected
        self.assertRaises(Unauthorized, self.folder.restrictedTraverse, 'secret_html')

    def testWebSecurity(self):
        # Test web security of public resource
        # Should be accessible
        urllib._urlopener = UnauthorizedOpener()
        try: urllib.urlopen(base+'/index_html')
        except Unauthorized: self.fail('Unauthorized')

    def testWebSecurity2(self):
        # Test web security of protected resource
        # Should be protected
        urllib._urlopener = UnauthorizedOpener()
        self.assertRaises(Unauthorized, urllib.urlopen, base+'/secret_html')

    def testAbsoluteURL(self):
        # Test absolute_url
        self.assertEquals(self.folder.absolute_url(), base)


if __name__ == '__main__':
    framework()
else:
    # While framework.py provides its own test_suite()
    # method the testrunner utility does not.
    from unittest import TestSuite, makeSuite
    def test_suite():
        suite = TestSuite()
        suite.addTest(makeSuite(TestWebserver))
        return suite

