#
# Parts of ZServer support are in this module so they can
# be imported more selectively
#

# $Id: threadutils.py,v 1.2 2003/10/23 19:44:49 uid134083 Exp $

from StringIO import StringIO as _StringIO
_dummyLOG = _StringIO()

_Z2LOG = _dummyLOG

def _zserverRunner(host, port):
    '''Runs an HTTP ZServer on host:port.'''
    from ZServer import logger, asyncore
    from ZServer import zhttp_server, zhttp_handler
    lg = logger.file_logger(_Z2LOG)
    hs = zhttp_server(ip=host, port=port, resolver=None, logger_object=lg)
    zh = zhttp_handler(module='Zope', uri_base='')
    hs.install_handler(zh)
    asyncore.loop()

from threading import Thread as _Thread

class _QuietThread(_Thread):
    def __init__(self, target=None, args=(), kwargs={}):
        _Thread.__init__(self, target=target, args=args, kwargs=kwargs)
        self._orig_bootstrap = _Thread._Thread__bootstrap
    def __bootstrap(self):
        try: self._orig_bootstrap(self)
        except: pass
    _Thread__bootstrap = __bootstrap

from ZServer.PubCore.ZServerPublisher import ZServerPublisher as _ZServerPublisher

def _QuietPublisher(self, accept):
    try: self._orig_init(accept)
    except: pass
_ZServerPublisher._orig_init = _ZServerPublisher.__init__
_ZServerPublisher.__init__ = _QuietPublisher

