#
# Utility functions
#
# These functions are designed to be imported and run at
# module level to add functionality to the test environment.
#

# $Id: utils.py,v 1.5 2003/11/28 15:54:45 shh42 Exp $

from Acquisition import aq_base

def setupCoreSessions(app):
    '''Sets up the session_data_manager e.a.'''
    commit = 0

    if not hasattr(app, 'temp_folder'):
        from Products.TemporaryFolder.TemporaryFolder import MountedTemporaryFolder
        tf = MountedTemporaryFolder('temp_folder','Temporary Folder')
        app._setObject('temp_folder', tf)
        commit = 1

    if not hasattr(aq_base(app.temp_folder), 'session_data'):
        from Products.Transience.Transience import TransientObjectContainer
        toc = TransientObjectContainer('session_data',
                    'Session Data Container',
                    timeout_mins=3,
                    limit=100)
        app.temp_folder._setObject('session_data', toc)
        commit = 1

    if not hasattr(app, 'browser_id_manager'):
        from Products.Sessions.BrowserIdManager import BrowserIdManager
        bid = BrowserIdManager('browser_id_manager',
                    'Browser Id Manager')
        app._setObject('browser_id_manager', bid)
        commit = 1

    if not hasattr(app, 'session_data_manager'):
        from Products.Sessions.SessionDataManager import SessionDataManager
        sdm = SessionDataManager('session_data_manager',
                    title='Session Data Manager',
                    path='/temp_folder/session_data',
                    requestName='SESSION')
        app._setObject('session_data_manager', sdm)
        commit = 1

    if commit: get_transaction().commit()


def setupZGlobals(app):
    '''Sets up the ZGlobals BTree required by ZClasses.'''
    root = app._p_jar.root()
    if not root.has_key('ZGlobals'):
        from BTrees.OOBTree import OOBTree
        root['ZGlobals'] = OOBTree()
        get_transaction().commit()


def setupSiteErrorLog(app):
    '''Sets up the error_log object required by ZPublisher.'''
    if not hasattr(app, 'error_log'):
        try:
            from Products.SiteErrorLog.SiteErrorLog import SiteErrorLog
        except ImportError:
            pass
        else:
            app._setObject('error_log', SiteErrorLog())
            get_transaction().commit()


import os, time

def importObjectFromFile(container, filename, quiet=0):
    '''Imports an object from a (.zexp) file into the given container.'''
    from ZopeLite import _print
    _start = time.time()
    if not quiet: _print("Importing %s ... " % os.path.basename(filename))
    container._importObjectFromFile(filename, verify=0)
    get_transaction().commit()
    if not quiet: _print('done (%.3fs)\n' % (time.time() - _start))


_Z2HOST = None
_Z2PORT = None

def startZServer(number_of_threads=1):
    '''Starts an HTTP ZServer thread.'''
    global _Z2HOST, _Z2PORT
    if _Z2HOST is None:
        import random
        _Z2HOST = '127.0.0.1'
        _Z2PORT = random.choice(range(55000, 55100))
        from ZServer import setNumberOfThreads
        setNumberOfThreads(number_of_threads)
        from threadutils import _QuietThread, _zserverRunner
        t = _QuietThread(target=_zserverRunner, args=(_Z2HOST, _Z2PORT))
        t.setDaemon(1)
        t.start()
    return _Z2HOST, _Z2PORT


import sys

def makerequest(app, stdout=sys.stdout):
    '''Wraps the app into a fresh REQUEST.'''
    from ZPublisher.HTTPRequest import HTTPRequest
    from ZPublisher.HTTPResponse import HTTPResponse
    from ZPublisher.BaseRequest import RequestContainer
    resp = HTTPResponse(stdout=stdout)
    environ = {}
    environ['SERVER_NAME'] = _Z2HOST or 'nohost'
    environ['SERVER_PORT'] = '%d' %(_Z2PORT or 80)
    environ['REQUEST_METHOD'] = 'GET'
    req = HTTPRequest(sys.stdin, environ, resp)
    return app.__of__(RequestContainer(REQUEST=req))


class ConnectionRegistry:

    def __init__(self):
        self._conns = []

    def register(self, conn):
        self._conns.append(conn)

    def close(self, conn):
        try: self._conns.remove(conn)
        except: pass
        try: conn.close()
        except: pass

    def closeAll(self):
        for conn in self._conns:
            try: conn.close()
            except: pass
        self._conns = []

    def __len__(self):
        return len(self._conns)


def _tranInfo(): return '%s' %get_transaction()
def _tranObjects(): return '%s' %get_transaction()._objects
def _tranDirty(): return len(get_transaction()._objects)

