#
# ztc_common.py
#
# This file must be called from framework.py like so
#
#   execfile(os.path.join(os.path.dirname(Testing.__file__),
#            'ZopeTestCase', 'ztc_common.py'))
#

# $Id: ztc_common.py,v 1.5 2003/11/27 19:48:36 shh42 Exp $


# Overwrites the default framework() method to expose the
# TestRunner parameters.
#
def framework(stream=sys.stderr, descriptions=1, verbosity=1):
    if __name__ != '__main__':
        return
    if len(sys.argv) > 1:
        arg = sys.argv[1]
        if arg in ('profile', 'profile-tests'):
            os.environ['PROFILE_TESTS'] = '1'
        elif arg == 'profile-setup':
            os.environ['PROFILE_SETUP'] = '1'
        elif arg == 'profile-teardown':
            os.environ['PROFILE_TEARDOWN'] = '1'
        else:
            sys.exit(globals()[arg]() and 1 or 0)
    errs = TestRunner(stream, descriptions, verbosity).run(test_suite())
    from Testing.ZopeTestCase import Profiler; Profiler.print_stats()
    sys.exit(errs and 1 or 0)


# Adds an INSTANCE_HOME instance to Products.__path__ and
# sys.path.
#
def _addInstanceHome(p):
    import Products
    pp = Products.__path__
    ip = os.path.join(p, 'Products')
    if os.path.isdir(ip) and ip not in pp:
        pp.insert(0, ip)
    ilp = os.path.join(p, 'lib', 'python')
    if os.path.isdir(ilp) and ilp not in sys.path:
        sys.path.insert(0, ilp)


# "main"
#
ZEO_INSTANCE_HOME = os.environ.get('ZEO_INSTANCE_HOME', '')
if ZEO_INSTANCE_HOME.endswith(os.sep):
    ZEO_INSTANCE_HOME = os.path.dirname(ZEO_INSTANCE_HOME)

if ZEO_INSTANCE_HOME:

    # If ZEO_INSTANCE_HOME has been given, assume a ZEO setup and use that
    # instance's custom_zodb.py to connect to a running ZEO server.
    #
    if os.path.isdir(os.path.join(ZEO_INSTANCE_HOME, 'Products')):
        if os.path.exists(os.path.join(ZEO_INSTANCE_HOME, 'custom_zodb.py')):
            _addInstanceHome(ZEO_INSTANCE_HOME)
            os.environ['INSTANCE_HOME'] = INSTANCE_HOME = ZEO_INSTANCE_HOME
        else:
            print 'Unable to locate custom_zodb.py in %s.' % ZEO_INSTANCE_HOME
            sys.exit(1)
    else:
        print 'Unable to locate Products directory in %s.' % ZEO_INSTANCE_HOME
        sys.exit(1)

else:

    # If INSTANCE_HOME has been given, add the instance's Products
    # and lib/python directories to the appropriate paths.
    #
    if __INSTANCE_HOME:
        if os.path.isdir(os.path.join(__INSTANCE_HOME, 'Products')):
            _addInstanceHome(__INSTANCE_HOME)
        else:
            print 'Unable to locate Products directory in %s.' % __INSTANCE_HOME
            sys.exit(1)

    # If INSTANCE_HOME has not been specified, try to detect whether we run
    # in an INSTANCE_HOME installation by walking up from cwd until we
    # find a 'Products' dir.
    #
    software_home = os.environ.get('SOFTWARE_HOME', '')
    cwd = os.getcwd()

    if not __INSTANCE_HOME and not cwd.startswith(software_home):
        p = d = cwd
        while d:
            if os.path.isdir(os.path.join(p, 'Products')):
                _addInstanceHome(p)
                break
            p, d = os.path.split(p)
        else:
            print 'Unable to locate Products directory.',
            print 'You might need to set INSTANCE_HOME.'
            sys.exit(1)

    # If there is a custom_zodb.py file in the tests dir, use it.
    # Note that the paths have already been changed at this point
    # so redirecting INSTANCE_HOME should be safe.
    #
    if os.path.exists(os.path.join(cwd, 'custom_zodb.py')):
        os.environ['INSTANCE_HOME'] = INSTANCE_HOME = cwd

