#####################################################################
# 
# Xron -- Zope Scheduled Event Product
# Copyright (C) 2000 Loren Stafford
#  
# Derived from the ZScheduler product version 0.0.7 in accord 
# with the terms of the ZScheduler's license.
#
# Based on code by Martijn Pieters, (c) 1999 Antraciet B.V.
# Used with explicit permission.
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License  
# along with this program; if not, write to the 
#     Free Software Foundation, Inc., 
#     59 Temple Place - Suite 330, 
#     Boston, MA  02111-1307, USA.
# 
#####################################################################
""" Scheduled DTML Methods for Xron """

from Globals import HTMLFile, default__class_init__
try:
  from Globals import DateTime
except ImportError:
  from DateTime import DateTime
from OFS.DTMLMethod import DTMLMethod
from Products.ZCatalog.CatalogAwareness import CatalogAware
from urllib import quote
import string

import Schedule
ScheduleID=Schedule.ScheduleID

#import pdb; pdb.set_trace()

class BaseXronDTMLMethod(CatalogAware, DTMLMethod):
  meta_type = 'Xron DTML Method'
  default_catalog = ScheduleID

  def __init__(self, id, title = '', file = ''):
    DTMLMethod.__init__(self, file, __name__ = id)

  manage_options=(
      {'label':'Edit', 'action':'manage_main', 
       'help':('Xron','XronDTMLMethod_Edit.stx')},
      {'label':'Upload', 'action':'manage_uploadForm'},
      {'label':'View', 'action':''},
      {'label':'Trigger', 'action':'manage_triggerXronEvent'},
      {'label':'Proxy', 'action':'manage_proxyForm'},
      {'label':'Security', 'action':'manage_access'},
                 )
  __ac_permissions__=(
    ('View management screens', (
        'manage_editForm', 'manage', 'manage_main', 'manage_uploadForm',
        'document_src', 'PrincipiaSearchSource')),
    ('Change DTML Methods', ('manage_edit', 'manage_upload', 'PUT')),
    ('Change proxy roles', ('manage_proxyForm', 'manage_proxy')),
    ('View', ('__call__', '')),
    ('FTP access', ('manage_FTPstat','manage_FTPget','manage_FTPlist')),
  )

  manage_editForm=HTMLFile('documentEdit', globals())
  manage=manage_main=manage_editDocument=manage_editForm
  try:
    manage_editForm._setName("manage_editForm")
  except AttributeError:
    pass
  import sys, string

  def nextEventTime():
    raise NotImplemented
      
  # Prevent changing the default_catalog
  manage_editCatalogerForm = None
  def manage_editCataloger(self, default):
    raise NotImplemented

  # Only index if nextEventTime returns something
  def index_object(self):
    if self.nextEventTime() is not None:
        CatalogAware.index_object.im_func(self)
        # see Python Reference Manual "The standard type hierarchy" 
        # for the built-in type im_func

  def disarm(self):
    """Private method for use only by the Dispatcher,
    when trigger fails.
    Marks the event as fired by nullifying its time.
    """
    self.executeAt=DateTime(0)
    self.reindex_object()

  def _arm(self, eventTime):
    """Private method for use only by the trigger to complete rescheduling
    Hides the rescheduling mechanism from the rescheduling
    policy implemented by overriddable method self.reschedule();
    Records the event in the Schedule catalog.
    """
    self.executeAt=eventTime
    self.reindex_object()
    
  def reschedule(self,REQUEST=None):
    """Implement rescheduling policy.
    This method is designed to be overridden by a ZClass DTML-method;
    so, it passes parameters via REQUEST.
    input:  REQUEST.XronEventOldTime a DateTime object
    output: REQUEST.XronEventTime a DateTime object
    Calculate REQUEST.XronEventTime as a function of REQUEST.XronEventOldTime
    """
    if self.periodDays:
        REQUEST.set('XronEventTime', REQUEST.XronEventOldTime+self.periodDays)
    else: 
        REQUEST.set('XronEventTime', DateTime(0))
    
  def trigger(self, client=None, REQUEST=None, RESPONSE=None, **kw):
    """For use by the Dispatcher to fire the event.
    Use also from the browser URL box to debug your events.
    Reschedules the event, then calls the action method.
    """
    if REQUEST is not None:
      REQUEST.set('XronEventOldTime',self.executeAt)
      self.reschedule(REQUEST=REQUEST)
      XronEventTime=REQUEST.XronEventTime
      #self._arm(XronEventTime)
      self.arm(REQUEST=REQUEST)
    else:
      self.disarm()
    #import pdb; pdb.set_trace() # debug
    try:
      return self.__call__(client=self, 
        REQUEST=REQUEST, RESPONSE=RESPONSE, kw=kw)
    except:
      import sys, traceback, string
      type, val, tb = sys.exc_info()
      fe=traceback.format_exception (type, val, tb)
      return string.join(fe, '\n')
      
  def manage_triggerXronEvent(self, client=None, REQUEST=None, RESPONSE=None, **kw):
    """For use by the Trigger tab on XronDTMLMethod management page.
    Use for testing the XronDTMLMethod in a request context.
    """
    aurl=REQUEST['URL1']
    furl=string.join((aurl, 'trigger'), '/')
    RESPONSE.redirect(furl)

  def arm(self, REQUEST=None):
    """Method to aid in programmatically setting 
    executeAt from a DTMLMethod.
    input: REQUEST.XronEventTime a DateTime object
    """
    self.executeAt=REQUEST.XronEventTime
    self.reindex_object()

default_event_html = 'Content-type: text/plain\n\n'

class XronDTMLMethod(BaseXronDTMLMethod):
  #meta_type = 'Xron DTML Method'

  def __init__(self, id, title = '', file = '', executeAt = None, periodDays = None):
    BaseXronDTMLMethod.__init__(self, id, title, file)
    if executeAt is None:
        executeAt = DateTime(0)
    self.executeAt = executeAt
    if periodDays is None:
        periodDays = 0.0
    self.periodDays = periodDays
    self.title = title

  def nextEventTime(self):
    #raise DEBUG, self.executeAt
    #if DateTime().lessThanEqualTo(self.executeAt):
    #    return self.executeAt
    #return None
    return self.executeAt

  def manage_edit(self,data,title,SUBMIT='Change',dtpref_cols='50',
                  dtpref_rows='20',REQUEST=None):
    """
    Added executeAt,periodDays to base DTMLMethod manage_edit
    """
    self._validateProxy(REQUEST)
    if self._size_changes.has_key(SUBMIT):
      return self._er(data,title,SUBMIT,dtpref_cols,dtpref_rows,REQUEST)
    self.title=title
    self.executeAt=REQUEST.executeAt
    self.periodDays=REQUEST.periodDays
    self.reindex_object()
    if type(data) is not type(''): data=data.read()
    self.munge(data)
    if REQUEST:
      message="Content changed."
      return self.manage_main(self,REQUEST,manage_tabs_message=message)

default__class_init__(XronDTMLMethod)

manage_addXronDTMLMethodForm = HTMLFile('addXronDTMLMethod', globals())

def manage_addXronDTMLMethod(
  self, id, title = '', file = '', executeAt = None, periodDays=0.0,
  REQUEST = None, submit = None):
  """Add an XronDTMLMethod object with the contents of file. 
  If 'file' is empty, default document text is used.
  """
  if type(file) is not type(''): file = file.read()
  if not file: file = default_event_html
  event=XronDTMLMethod(id, title, file, executeAt, periodDays)
  id=self._setObject(id, event)
  if REQUEST is not None:
    try: u=self.DestinationURL()
    except: u=REQUEST['URL1']
    if submit==" Add and Edit ": u="%s/%s" % (u,quote(id))
    REQUEST.RESPONSE.redirect(u+'/manage_main')
  return ''

