##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""
ZAttachmentAttribute product

Configuration file.
You can edit this file.
"""

import sys
import App.Common
import os.path

from Products.ZAttachmentAttribute.Log import *

import os
import string

# Converter program
PACKAGE_HOME = App.Common.package_home(globals())
PDF2TEXT_PROGRAM = None
if sys.platform == 'win32':
    # Windows platform
    PDF2TEXT_PROGRAM = '"' + os.path.join(PACKAGE_HOME, "win32", "pdftotext.exe", ) + '"' 
    Log(LOG_DEBUG, "Using '%s'." % (PDF2TEXT_PROGRAM,))
    try:
        open(PDF2TEXT_PROGRAM[1:-1], "r")
    except:
        Log(LOG_WARNING, "Converter program '%s' not found ! Please check your installation" % (PDF2TEXT_PROGRAM,))

else:
    # Unix platform
    import commands
    program = commands.getoutput("which pdftotext")
    if not program:
        Log(LOG_WARNING, "PDFAttachment: pdftotext not found ! Indexing won't work.")
    else:
        PDF2TEXT_PROGRAM = string.strip(program)
        Log(LOG_NOTICE, "PDFAttachment: Using '%s' for indexing." % (PDF2TEXT_PROGRAM, ))
