###################################################################################################
# _confmanager.py
#
# $Id: _confmanager.py,v 1.5 2004/02/24 19:57:21 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.5 $
#
# Implementation of class Configuration-Manager (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from __future__ import nested_scopes
from App.Common import package_home
from Globals import HTMLFile
from OFS.Image import Image
import os
import stat
import urllib
# Product imports.
import _globals
import _fileutil
import _filtermanager
import _mediadb
import _metadictmanager
import _metacmdmanager
import _metaobjmanager
import _metapatternmanager
import _multilangmanager
import _sequence
import _textformatmanager
import _workflowmanager


"""
###################################################################################################
###
###   Initialization
###
###################################################################################################
"""

# -------------------------------------------------------------------------------------------------
#  _confmanager.initConf:
# -------------------------------------------------------------------------------------------------
def initConf(self, profile, REQUEST):
  filenames = self.getConfFiles()
  for filename in filenames:
    if filename.find(profile + '.') == 0:
      self.importConf(filename,REQUEST,1)


# -------------------------------------------------------------------------------------------------
#  _confmanager.updateConf:
# -------------------------------------------------------------------------------------------------
def updateConf(self, REQUEST):
  filenames = self.getConfFiles()
  for filename in filenames:
    self.importConf(filename,REQUEST,0)


###################################################################################################
###################################################################################################
###
###   class ConfManager:
###
###################################################################################################
###################################################################################################
class ConfManager(
	_multilangmanager.MultiLanguageManager,		# Languages
	_metadictmanager.MetadictManager,		# Metadata
	_metaobjmanager.MetaobjManager,			# Spec. Objects
	_metapatternmanager.MetapatternManager,		# Modules
	_metacmdmanager.MetacmdManager,			# Actions
	_workflowmanager.WorkflowManager,		# Workflow
	_textformatmanager.TextFormatManager,		# Formats
	_filtermanager.FilterManager,			# Filters (XML Im-/Export)
	):
        
    # Management Interface.
    # ---------------------
    manage_customize = HTMLFile('dtml/zms/manage_customize', globals()) 
    manage_customizeDesignForm = HTMLFile('dtml/zms/manage_customizedesignform', globals()) 


    # -------------------------------------------------------------------------------------------------
    #  ConfManager.importConf:
    # -------------------------------------------------------------------------------------------------
    def importConf(self, filename, REQUEST, createIfNotExists=0):
      filepath = package_home(globals())+'/import/'
      xmlfile = open(_fileutil.getOSPath(filepath+filename),'rb')
      if filename.find('.filter.') > 0:
        _filtermanager.importXml(self, xmlfile, REQUEST, 1, createIfNotExists)
      elif filename.find('.metadict.') > 0:
        _metadictmanager.importXml(self, xmlfile, REQUEST, 1, createIfNotExists)
      elif filename.find('.metaobj.') > 0:
        _metaobjmanager.importXml(self, xmlfile, REQUEST, 1, createIfNotExists)
      elif filename.find('.metacmd.') > 0:
        _metacmdmanager.importXml(self, xmlfile, REQUEST, 1, createIfNotExists)
      xmlfile.close()


    # -------------------------------------------------------------------------------------------------
    #  ConfManager.getConfFiles:
    #
    #  Returns configuration-files from $ZMS_HOME/import-Folder
    # -------------------------------------------------------------------------------------------------
    def getConfFiles(self, pattern=None):
      filenames = []
      filepath = package_home(globals())+'/import/'
      for filename in os.listdir(filepath):
        path = filepath + os.sep + filename
        mode = os.stat(path)[stat.ST_MODE]
        if not stat.S_ISDIR(mode):
          filenames.append(filename)
      if pattern is not None:
        filenames = filter(lambda x: x.find(pattern) >= 0, filenames)
      return filenames


    """
    ###############################################################################################    
    ###
    ###   Configuration-Properties Getters
    ###
    ###############################################################################################    
    """

    # ---------------------------------------------------------------------------------------------
    #  ConfManager.getSequence:
    #
    #  Returns sequence.
    # ---------------------------------------------------------------------------------------------
    def getSequence(self):
      id = 'acl_sequence'
      if id not in self.objectIds(['Sequence']):
        _sequence.manage_addSequence(self)
      ob = getattr(self,id)
      return ob

    # ---------------------------------------------------------------------------------------------
    #  ConfManager.getMediaDb:
    #
    #  Returns mediadb.
    # ---------------------------------------------------------------------------------------------
    def getMediaDb(self):
      return getattr(self,'acl_mediadb',None)

    # ---------------------------------------------------------------------------------------------
    #  ConfManager.getStylesheet:
    #
    #  Returns stylesheet.
    # ---------------------------------------------------------------------------------------------
    def getStylesheet(self, defaultCSS=''):
      id = 'stylesheet.css'
      title = '*** DO NOT DELETE OR MODIFY ***'
      if id not in self.objectIds(['DTML Method']):
        raw = ''
        self.manage_addDTMLMethod(id,title,raw)
      ob = getattr(self,id)
      if len(defaultCSS)>0:
        ob.manage_edit(defaultCSS,title)
      return ob


    """
    ###############################################################################################    
    ###
    ###   Configuration-Tab Options
    ###
    ###############################################################################################    
    """
    
    # -------------------------------------------------------------------------------------------------
    #  ConfManager.customize_manage_options:
    # -------------------------------------------------------------------------------------------------
    def customize_manage_options(self, lang, manage_lang, REQUEST):
      options = []
      options.append({'label':self.getLangStr('TAB_SYSTEM',manage_lang),'action':'manage_customize'})
      options.append({'label':self.getLangStr('TAB_LANGUAGES',manage_lang),'action':'manage_customizeLanguagesForm'})
      options.append({'label':self.getLangStr('TAB_METADATA',manage_lang),'action':'manage_customizeMetadictForm'})
      options.append({'label':self.getLangStr('TAB_METAOBJ',manage_lang),'action':'manage_customizeMetaobjForm'})
      options.append({'label':self.getLangStr('TAB_METAPATTERN',manage_lang),'action':'manage_customizeMetapatternForm'})
      options.append({'label':self.getLangStr('TAB_METACMD',manage_lang),'action':'manage_customizeMetacmdForm'})
      options.append({'label':self.getLangStr('TAB_WORKFLOW',manage_lang),'action':'manage_customizeWorkflowForm'})
      options.append({'label':self.getLangStr('TAB_TEXTFORMAT',manage_lang),'action':'manage_customizeTextFormatForm'})
      options.append({'label':self.getLangStr('TAB_FILTER',manage_lang),'action':'manage_customizeFilterForm'})
      options.append({'label':self.getLangStr('TAB_DESIGN',manage_lang),'action':'manage_customizeDesignForm'})
      return options


    """
    ###############################################################################################    
    ###
    ###   Configuration-Properties
    ###
    ###############################################################################################    
    """

    # ---------------------------------------------------------------------------------------------
    #  ConfManager.__get_attr_conf_dict__:
    #
    #  Returns property from configuration.
    # ---------------------------------------------------------------------------------------------
    def __get_attr_conf_dict__(self):
      return getattr(self,'__attr_conf_dict__',{})

    # ---------------------------------------------------------------------------------------------
    #  ConfManager.getConfProperty:
    #
    #  Returns property from configuration.
    # ---------------------------------------------------------------------------------------------
    def getConfProperty(self, key, default=None):
      v = default
      attr_conf_dict = self.__get_attr_conf_dict__()
      if attr_conf_dict.has_key(key):
        v = attr_conf_dict[key]
      return v

    # ---------------------------------------------------------------------------------------------
    #  ConfManager.setConfProperty:
    #
    #  Returns property from configuration.
    # ---------------------------------------------------------------------------------------------
    def setConfProperty(self, key, value):
      attr_conf_dict = self.__get_attr_conf_dict__()
      if value is None or value=='':
        if attr_conf_dict.has_key(key):
          del attr_conf_dict[key]
      else:
        attr_conf_dict[key] = value
      self.__attr_conf_dict__ = attr_conf_dict
      self.__attr_conf_dict__ = self.__attr_conf_dict__.copy()


    """
    ###############################################################################################    
    ###
    ###   Configuration-System
    ###
    ###############################################################################################    
    """

    ###############################################################################################
    #  ConfManager.manage_customizeSystem: 
    #
    #  Customize system properties.
    ###############################################################################################
    def manage_customizeSystem(self, btn, key, lang, manage_lang, REQUEST, RESPONSE): 
      """ ConfManager.manage_customizeSystem """
      
      message = ''
      
      ##### ASP ####
      if key == 'ASP':
        self.setConfProperty('ZMSAdministrator.email',REQUEST.get('zmsadministrator_email',''))
        self.setConfProperty('ASP.ip_or_domain',REQUEST.get('asp_ip_or_domain',''))
        message = self.getLangStr('MSG_CHANGED',manage_lang)
      
      ##### History ####
      elif key == 'History':
        self.setConfProperty('ZMS.Version.active',REQUEST.get('active',0))
        self.setConfProperty('ZMS.Version.autopack',REQUEST.get('autopack',''))
        if self.getConfProperty('ZMS.Version.active',0)==0 or btn == 'Pack':
          self.run_pack_history(forced=1)
        message = self.getLangStr('MSG_CHANGED',manage_lang)
      
      ##### Version ####
      elif key == 'Version':
        if btn == 'Regenerate':
          message = self.recurse_updateVersion(REQUEST)
      
      ##### Catalog ####
      elif key == 'Catalog':
        if btn == 'Change':
          self.setConfProperty('ZMS.CatalogAwareness.active',REQUEST.get('active',0))
          message = self.getLangStr('MSG_CHANGED',manage_lang)
        elif btn == 'Refresh':
          message = self.reindexCatalog(REQUEST)
      
      ##### Clients ####
      elif key == 'Clients':
        if btn == 'Change':
          s = REQUEST.get('portal_master','').strip()
          if s != self.getHome().id:
            self.setConfProperty('Portal.Master',s)
          l = []
          for s in REQUEST.get('portal_clients','').split('\n'):
            s = s.strip()
            if s in self.getHome().objectIds(['Folder']):
              l.append(s)
          self.setConfProperty('Portal.Clients',l)
          message = self.getLangStr('MSG_CHANGED',manage_lang)
      
      ##### MediaDb ####
      elif key == 'MediaDb':
        if btn == 'Create':
          location = REQUEST['mediadb_location'].strip()
          _mediadb.manage_addMediaDb(self,location)
          message = self.getLangStr('MSG_CHANGED',manage_lang)
        elif btn == 'Pack':
          message = _mediadb.manage_packMediaDb(self)
        elif btn == 'Remove':
          message = _mediadb.manage_delMediaDb(self)
      
      ##### Custom ####
      elif key == 'Custom':
        if btn == 'Change':
          self.setConfProperty(REQUEST['option'],REQUEST.get('value',''))
          message = self.getLangStr('MSG_CHANGED',manage_lang)
      
      ##### InstalledProducts ####
      elif key == 'InstalledProducts':
        if btn == 'Change':
          self.setConfProperty('ZMS.demo',REQUEST.get('demo_active',0))
          self.setConfProperty('InstalledProducts.pil',REQUEST.get('pil',None))
          self.setConfProperty('InstalledProducts.pil.scale',REQUEST.get('pil_scale',0))
          self.setConfProperty('InstalledProducts.pil.thumbnail',REQUEST.get('pil_thumbnail',0))
          self.setConfProperty('InstalledProducts.pil.thumbnail.max',REQUEST.get('pil_thumbnail_max',100))
          self.setConfProperty('InstalledProducts.pil.superres',REQUEST.get('pil_superres',0))
          self.setConfProperty('InstalledProducts.pil.hires.thumbnail.max',REQUEST.get('pil_hires_thumbnail_max',600))
          message = self.getLangStr('MSG_CHANGED',manage_lang)
      
      ##### StandardObjects ####
      elif key == 'StandardObjects':
        meta_types = []
        meta_types.extend(self.dGlobalAttrs.keys())
        meta_types.extend(self.getMetaobjIds())
        for meta_type in meta_types:
          self.setConfProperty('%s.enabled'%meta_type,meta_type in REQUEST.get('meta_types',[]))
        message = self.getLangStr('MSG_CHANGED',manage_lang)
      
      ##### InstalledProducts ####
      elif key == 'Log':
        if btn == 'Change':
          self.setConfProperty('ZMS.log.keep_entries',REQUEST.get('keep_entries',0))

      # Return with message.
      message = urllib.quote(message)
      return RESPONSE.redirect('manage_customize?lang=%s&manage_lang=%s&option=%s&manage_tabs_message=%s#_%s'%(lang,manage_lang,str(REQUEST.get('option','')),message,key))


    """
    ###############################################################################################    
    ###
    ###   Configuration-Design
    ###
    ###############################################################################################    
    """

    ###############################################################################################
    #  ConfManager.manage_customizeDesign: 
    #
    #  Customize design properties.
    ###############################################################################################
    def manage_customizeDesign(self, btn, lang, manage_lang, REQUEST, RESPONSE):
      """ ConfManager.manage_customizeDesign """
      message = ''
      
      # Change.
      # -------
      if btn == self.getLangStr('BTN_CHANGE',manage_lang):
        #-- Stylesheet.
        if REQUEST.has_key('stylesheet'):
          method = self.getStylesheet()
          data = REQUEST['stylesheet']
          title = method.title
          method.manage_edit(data,title)
        #-- Sitemap.
        if REQUEST.has_key('attr_layoutsitemap'):
          if len(REQUEST['attr_layoutsitemap'])>0:
            self.attr_layoutsitemap = int(REQUEST['attr_layoutsitemap'])
          elif hasattr(self,'attr_layoutsitemap'):
            delattr(self,'attr_layoutsitemap')
        #-- Skin.
        self.setConfProperty('ZMS.skin',REQUEST.get('skin',''))
      
      # Upload.
      # -------
      elif btn == self.getLangStr('BTN_UPLOAD',manage_lang):
        #-- Logo.
        self.logo = Image(id='logo', title='', file='')
        self.logo.manage_upload(REQUEST['file'],REQUEST)
      
      # Return with message.
      message = urllib.quote(self.getLangStr('MSG_CHANGED',manage_lang))
      return RESPONSE.redirect('manage_customizeDesignForm?lang=%s&manage_lang=%s&manage_tabs_message=%s'%(lang,manage_lang,message))

###################################################################################################
