###################################################################################################
# _exportable.py
#
# $Id: _exportable.py,v 1.5 2004/02/24 19:57:21 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.5 $
#
# Implementation of class Exportable (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from App.Common import package_home
from OFS.Image import Image
import urllib
import tempfile
import os
# Product Imports.
from _globals import *
import _blobfields
import _fileutil
import _filtermanager
import _xmllib


# ---------------------------------------------------------------------------------------------
#  _exportable.exportCommon:
# ---------------------------------------------------------------------------------------------
def exportCommon(root, path, id):
  if hasattr(root,id):
    folder = getattr(root,id)
    if folder.meta_type == 'Folder':
      for ob in folder.objectValues():
        if ob.meta_type == 'Folder':
          ob_id = ob.id
          exportCommon(ob,'%s/%s'%(path,id),ob_id)
        else:
          ob_id = ob.id()
          _fileutil.exportObj(ob,'%s/%s/%s'%(path,id,ob_id))


# ---------------------------------------------------------------------------------------------
#  _exportable.findDelimiter:
# ---------------------------------------------------------------------------------------------
def findDelimiter(s, delimiters=['"',"'"]):
  rtn = -1
  for delimiter in delimiters:
    i = s.find(delimiter)
    if rtn == -1:
      rtn = i
    elif i >= 0:
      rtn = min(rtn,i)
  return rtn


# ---------------------------------------------------------------------------------------------
#  _exportable.rfindDelimiter:
# ---------------------------------------------------------------------------------------------
def rfindDelimiter(s, delimiters=['"',"'"]):
  rtn = -1
  for delimiter in delimiters:
    i = s.rfind(delimiter)
    rtn = max(rtn,i)
  return rtn


# ---------------------------------------------------------------------------------------------
#  _exportable.localHtml:
# ---------------------------------------------------------------------------------------------
def localHtml(self, obj, html, REQUEST):
  
  # Process relative links to Blob-Fields (Images and Files).
  # ---------------------------------------------------------
  
  # [i]
  for s_blob in ['blob_html?','f_zoomImage?']:
    i = html.find(s_blob)
    while i > 0:
      k = rfindDelimiter(html[:i])
      j = html[k:i-1].rfind('/')
      if j < 0:
        s_blob_id = obj.id
        o_blob = obj
        s_new = '"'
      else:
        s_blob_id = html[k+j+1:i-1]
        o_blob = self.findObjId(s_blob_id,REQUEST)
        s_new = '%s/'%s_blob_id
      s_old = s_new + s_blob
      if o_blob is not None:
        l = html[i:].find('key=')
        m = html[i+l:].find('&')
        s_key = html[i+l+4:i+l+m]
        value = o_blob.getObjProperty(s_key,REQUEST)
        filename = getattr(value,'filename',None)
        if filename is not None:
          s_new += filename
      s_new += '?'
      if len(s_old) > 0: html = html.replace(s_old,s_new)
      i = html.find(s_blob)
  
  # [ii]
  s_blob = '?key='
  i = html.find(s_blob)
  while i > 0:
    k = findDelimiter(html[i:])
    s_old = html[i:i+k]
    s_new = ''
    if len(s_old) > 0: html = html.replace(s_old,s_new)
    i = html.find(s_blob)
  
  # Process relative links to JavaScript.
  # -------------------------------------
  for js in ['comlib','formlib']:
    s_old = '%s_js?lang=%s"'%(js,REQUEST['lang'])
    s_new = '%s.js"'%(js)
    if len(s_old) > 0: html = html.replace(s_old,s_new)
  
  return html


# ---------------------------------------------------------------------------------------------
#  _exportable.localPrintHtml:
# ---------------------------------------------------------------------------------------------
def localPrintHtml(self, obj, html, REQUEST):
  
  # Process absolute URLs.
  s_old = '"%s/'%self.getDocumentElement().absolute_url()
  s_new = '"'
  if len(s_old) > 0: html = html.replace(s_old,s_new)
  
  # Process relative links to Child-Objects.
  for child in obj.getChildNodes(REQUEST):
    s_old = '"%s'%child.id
    s_new = '"./%s'%child.relative_obj_path()
    if len(s_old) > 0: html = html.replace(s_old,s_new)
  
  # Remove styles.
  startStyle = "<style"
  endStyle = "</style>"
  i = html.find(startStyle)
  j = html.find(endStyle)
  while i >= 0 and  j > i:
    html = html[0:i] + html[j+len(endStyle):]
    i = html.find(startStyle)
    j = html.find(endStyle)
  
  return html


# ---------------------------------------------------------------------------------------------
#  _exportable.localIndexHtml:
# ---------------------------------------------------------------------------------------------
def localIndexHtml(self, obj, html, REQUEST):
   
   sRoot = ''
   for i in range(obj.getLevel()):
     sRoot = '../%s'%sRoot
   
   # Process absolute URLs
   s_new = '%s'%sRoot
   s_old = '%s/'%self.getDocumentElement().absolute_url()
   html = html.replace(s_old,s_new)
   s_old = '%s/'%self.getHome().absolute_url()
   html = html.replace(s_old,s_new)
   
   # Process links to common-Folder (resource-Directory: Images and Assets).
   s_new = '"%scommon/'%sRoot
   s_old = '"./common/'
   html = html.replace(s_old,s_new)
   s_old = '"common/'
   html = html.replace(s_old,s_new)
   
   # Process links to Product-Folder (resource-Directory: Images and Assets).
   s_new = '"%smisc_/zms/'%sRoot
   s_old = '"/misc_/zms/'
   html = html.replace(s_old,s_new)
   s_old = '"misc_/zms/'
   html = html.replace(s_old,s_new)
   
   # Process preview parameters.
   s_new = ''
   s_old = '?preview=preview'
   html = html.replace(s_old,s_new)
   s_old = '&preview=preview'
   html = html.replace(s_old,s_new)
   
   return html


###################################################################################################
###################################################################################################
###
###   class Exportable
###
###################################################################################################
###################################################################################################
class Exportable:

    ###############################################################################################    
    #  Exportable.manage_export:
    #
    #  Exports ZMS-object.
    ###############################################################################################    
    def manage_export(self, export_format, lang, manage_lang, REQUEST, RESPONSE):
        """ Exportable.manage_export """
        
        title = self.getHome().id + '_' + id_quote(self.getTitlealt(REQUEST))
        
	# Get export format.
        try:
          export_format = int(export_format)
        except:
          pass
        
        # ZEXP.
        if export_format == 0:
          filename = '%s.zexp'%self.id
          export = self.aq_parent.manage_exportObject(id=self.id, download=1)
          content_type = 'application/data'
        
        # HTML.
        elif export_format == 1:
          filename = '%s_html.zip'%title
          export = self.toZippedHtml(REQUEST)
          content_type = 'application/zip'
        
        # XML.
        elif export_format == 2: 
          filename = '%s_xml.zip'%title
          export = self.toZippedXml(REQUEST)
          content_type = 'application/zip'
        
        # Export Filter.
        elif export_format in self.getFilterIds():
          filename, export, content_type = _filtermanager.exportFilter(self, export_format, REQUEST)
        
        # return export for download to browser
        RESPONSE.setHeader('Content-Type',content_type)
        RESPONSE.setHeader('Content-Disposition','inline;filename=%s'%filename)
        return export


    # ---------------------------------------------------------------------------------------------
    #  Exportable.toXml:
    # ---------------------------------------------------------------------------------------------
    def toXml(self, REQUEST):
      return _xmllib.xml_header() + _xmllib.getObjToXml(self,REQUEST)


    # ---------------------------------------------------------------------------------------------
    #  Exportable.__prepare_temp_export_folder__:
    #
    #  Return path with resources (Images, StyleSheets, etc.)
    # ---------------------------------------------------------------------------------------------
    def __prepare_temp_export_folder__(self, REQUEST, from_content=1, from_zms=0, from_common=0):
        
        #-- Create temporary folder.
        tempfolder = tempfile.mktemp()
        
        # Copy resource files.
        # --------------------
        
        # from ZMS.
        if from_zms:
          folder = 'misc_/zms'
          for obj_id in self.misc_.zms._d.keys():
            _fileutil.exportObj(self.misc_.zms[obj_id],'%s/%s/%s'%(tempfolder,folder,obj_id))
        
        # from common directory (template-specific: Grafiken und Assets).
        if from_common:
          exportCommon(self.getHome(),tempfolder,'common')
        
        # from content.
        if from_content:
          
          if REQUEST is not None:
          
            # Save CStyleSheet to file.
            # -------------------------
            lang = REQUEST.get('lang',None)
	    obj = self.getStylesheet()
	    for langId in self.getLangIds():
              REQUEST.set('ZMS_HTML_EXPORT',1)
              REQUEST.set('lang',langId)
              REQUEST.set('preview',None)
              data = obj(obj,REQUEST)
	      # Save data to file.
              filename = 'stylesheet_%s.css'%langId
              _fileutil.exportObj(data,'%s/%s'%(tempfolder,filename))
            REQUEST.set('lang',lang)
          
            # Save JavaScript to file.
            # ------------------------
            for js in ['comlib','formlib']:
              data = getattr(self,'%s_js'%(js))(self,REQUEST)
	      # Save data to file.
              filename = '%s.js'%js
              _fileutil.exportObj(data,'%s/%s'%(tempfolder,filename))
          
          # Download ressources (images & files)
          _blobfields.recurse_downloadRessources(self,tempfolder)
        
        return tempfolder


    # ---------------------------------------------------------------------------------------------
    #	Exportable.recurse_downloadHtmlPages:
    # ---------------------------------------------------------------------------------------------
    def recurse_downloadHtmlPages(self, obj, path, REQUEST):
      
      if len(obj.getChildNodes()) > 0:
         
         try:
           os.mkdir(path)
         except:
           pass
         
         dctOp = {'index':'','sitemap':'sitemap','index_print':'print'}
         for lang in self.getLangIds():
           for key in dctOp.keys():
             
             # Get html.
             REQUEST.set('ZMS_HTML_EXPORT',1)
             REQUEST.set('lang',lang)
             REQUEST.set('preview',None)
             REQUEST.set('op',dctOp[key])
             html = obj.index_html(obj,REQUEST)
             html = localHtml(self,obj,html,REQUEST)
             html = localIndexHtml(self,obj,html,REQUEST)
             
             # Save html to file.
             filename = '%s/%s_%s.html'%(path,key,lang)
             f = open(filename,'w')
             f.write(html)
             f.close()
             
             # Root folder requires and defaults to "index.html" at most systems.
             if key == 'index' and \
                lang == self.getPrimaryLanguage() and \
                obj.getLevel() == 0:
               filename = '%s/%s.html'%(path,key)
               f = open(filename,'w')
               f.write(html)
               f.close()
         
         # Process children.
         for child in obj.getChildNodes():
           self.recurse_downloadHtmlPages(child,'%s/%s'%(path,child.id),REQUEST)


    # ---------------------------------------------------------------------------------------------
    #	Exportable.toZippedHtml:
    # ---------------------------------------------------------------------------------------------
    def toZippedHtml(self, REQUEST):
      
      #-- Create temporary folder.
      tempfolder = self.__prepare_temp_export_folder__(REQUEST=REQUEST,from_content=1,from_zms=1,from_common=1)
      
      #-- Download HTML-pages.
      self.recurse_downloadHtmlPages(self,tempfolder,REQUEST)
      
      #-- Get zip-file.
      rtn = _fileutil.buildZipArchive('%s/*.*'%tempfolder)
      
      #-- Remove temporary folder.
      _fileutil.remove(tempfolder,deep=1)
      
      return rtn


    # ---------------------------------------------------------------------------------------------
    #  Exportable.toZippedXml:
    # ---------------------------------------------------------------------------------------------
    def toZippedXml(self, REQUEST):
      
      #-- Create temporary folder.
      folder = self.__prepare_temp_export_folder__(REQUEST)
      
      #-- Get xml-export.
      xml = self.toXml(REQUEST)
      
      #-- Write xml-export to file.
      xmlfilename = _fileutil.getOSPath('%s/%s_%s.xml'%(folder,self.getHome().id,self.meta_type))
      _fileutil.exportObj(xml,xmlfilename)
      
      #-- Get zip-file.
      zipfiles = _fileutil.getOSPath('%s/*.*'%folder)
      rtn = _fileutil.buildZipArchive(zipfiles)
      
      #-- Remove temporary folder.
      _fileutil.remove(folder,deep=1)
      
      return rtn


###################################################################################################
