###################################################################################################
# _copysupport.py
#
# $Id: _copysupport.py,v 1.7 2004/11/24 21:02:52 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.7 $
#
# Implementation of class CopySupport (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from __future__ import nested_scopes
import string 
import urllib
from OFS import Moniker
from OFS.CopySupport import _cb_decode, _cb_encode, absattr, CopyError, eNoData, eInvalid
# Product Imports.
import _globals


###################################################################################################
###################################################################################################
###
###   C l a s s   C o p y S u p p o r t 
###
###################################################################################################
###################################################################################################
class CopySupport:

    # ------------------------------------------------------------------------------------------
    #  CopySupport._get_cb_copy_data:
    # ------------------------------------------------------------------------------------------
    def _get_cb_copy_data(self, cb_copy_data=None, REQUEST=None):
      cp=None
      if cb_copy_data is not None:
        cp=cb_copy_data
      else:
        if REQUEST and REQUEST.has_key('__cp'):
          cp=REQUEST['__cp']
      if cp is None:
        raise CopyError, eNoData
      
      try: cp=_cb_decode(cp)
      except: raise CopyError, eInvalid
      
      return cp

    # ------------------------------------------------------------------------------------------
    #  CopySupport._get_obs:
    # ------------------------------------------------------------------------------------------
    def _get_obs(self, cp):
        
        try: cp=_cb_decode(cp)
        except: raise CopyError, eInvalid
        
        oblist=[]
        op=cp[0]
        app = self.getPhysicalRoot()
        
        for mdata in cp[1]:
          m = Moniker.loadMoniker(mdata)
          try: ob = m.bind(app)
          except: raise CopyError, eNotFound
          self._verifyObjectPaste(ob)
          oblist.append(ob)
        
        return oblist


    # ------------------------------------------------------------------------------------------
    #  CopySupport._get_ids:
    # ------------------------------------------------------------------------------------------
    def _get_ids(self, cp):
      return map(lambda ob: self._get_id(absattr(ob.id)),self._get_obs(cp))


    # ------------------------------------------------------------------------------------------
    #  CopySupport._get_id:
    #
    #  Allow containers to override the generation of
    #  object copy id by attempting to call its _get_id
    #  method, if it exists.
    # ------------------------------------------------------------------------------------------
    def _get_id(self, id):
      return 'copy_of_%s'%id 


    # ------------------------------------------------------------------------------------------
    #  CopySupport._set_sort_ids:
    # ------------------------------------------------------------------------------------------
    def _set_sort_ids(self, ids, op, REQUEST):
      sort_id = REQUEST.get('_sort_id',0)
      for ob in self.getChildNodes():
        id = absattr(ob.id)
        if id in ids or (op==1 and 'copy_of_%s'%id in ids):
          for obj_vers in ob.getObjVersions():
            setattr(obj_vers,'sort_id',_globals.format_sort_id(sort_id))
          sort_id = sort_id + 1


    # ------------------------------------------------------------------------------------------
    #  CopySupport._normalize_ids_after_copy:
    # ------------------------------------------------------------------------------------------
    def _normalize_ids_after_copy(self, ids=[], forced=0, REQUEST={}):
      copy_of_prefix = 'copy_of_'
      if _globals.debug( self): 
        _globals.writeLog( self, "[_normalize_ids_after_copy]: %s"%self.absolute_url())
      for ob in self.objectValues( self.dGlobalAttrs.keys()):
        id = absattr(ob.id)
        if id in ids or forced:
          if _globals.debug( self): 
            _globals.writeLog( self, '[_normalize_ids_after_copy]: %s.%s(%s)'%(self.id,id,ob.meta_type))
          
          # Assign new id.
          id_prefix = _globals.id_prefix(id)
          if id_prefix.find(copy_of_prefix)==0:
            id_prefix = id_prefix[len(copy_of_prefix):]
          if id_prefix != id:
            new_id = self.getNewId(id_prefix)
            self.manage_renameObject(id=id,new_id=new_id)
          
          for s_lang in self.getLangIds():
            for s_preview in ['preview']:
              req = {'lang':s_lang,'preview':s_preview,'AUTHENTICATED_USER':self.REQUEST['AUTHENTICATED_USER']}
              if forced==0:
                # Object-State and Version-Manager.
                ob.setObjStateNew(req,reset=0)
                ob.onChangeObj(req)
              # Process referential integrity.
              ob.onCopyRefObj(req)
              # Unlock.
              ob.checkIn(req)
          
          # Process tree.
          ob._normalize_ids_after_copy(ids=ids,forced=1,REQUEST=REQUEST)


    # ------------------------------------------------------------------------------------------
    #  CopySupport._normalize_ids_after_move:
    # ------------------------------------------------------------------------------------------
    def _normalize_ids_after_move(self, ids=[], forced=0, REQUEST={}):
      copy_of_prefix = 'copy_of_'
      if _globals.debug( self): 
        _globals.writeLog( self, "[_normalize_ids_after_move]: %s"%self.absolute_url())
      for ob in self.objectValues( self.dGlobalAttrs.keys()):
        id = absattr(ob.id)
        if id in ids or forced:
          if _globals.debug( self): 
            _globals.writeLog( self, '[_normalize_ids_after_move]: %s.%s(%s)'%(self.id,id,ob.meta_type))
          
          # Re-Assign old id.
          if id.find(copy_of_prefix)==0:
            try:
              new_id = id[len(copy_of_prefix):]
              self.manage_renameObject(id=id,new_id=new_id)
            except:
              pass
            
          for s_lang in self.getLangIds():
            for s_preview in ['preview']:
              req = {'lang':s_lang,'preview':s_preview,'AUTHENTICATED_USER':self.REQUEST['AUTHENTICATED_USER']}
              if forced==0:
                # Object-State and Version-Manager.
                ob.setObjStateModified(req)
                ob.onChangeObj(req)
              # Process referential integrity.
              ob.onMoveRefObj(req)
              # Unlock.
              ob.checkIn(req)
          
          # Process tree.
          ob._normalize_ids_after_move(ids=ids,forced=1,REQUEST=REQUEST)


    ###############################################################################################
    # CopySupport.manage_pasteObjs: 
    #
    # Paste previously copied objects into the current object.
    # If calling manage_pasteObjects from python code, pass
    # the result of a previous call to manage_cutObjects or
    # manage_copyObjects as the first argument.
    ###############################################################################################
    def manage_pasteObjs(self, REQUEST, RESPONSE=None):
      """ CopySupport.manage_pasteObjs """
      if _globals.debug( self): 
        _globals.writeLog( self, "[manage_pasteObjs]")
      
      # Analyze request
      cp=self._get_cb_copy_data(cb_copy_data=None,REQUEST=REQUEST)
      op=cp[0]
      cp = (0,cp[1])
      cp = _cb_encode(cp)
      ids = self._get_ids(cp)
      oblist = self._get_obs(cp)

      # Paste objects.
      self.manage_pasteObjects(cb_copy_data=None,REQUEST=REQUEST)

      # Sort order (I).
      self._set_sort_ids(ids=ids,op=op,REQUEST=REQUEST)
      
      # Move objects.
      if op==1:
        self._normalize_ids_after_move(ids=ids,forced=0,REQUEST=REQUEST)
      # Copy objects.
      else:
        self._normalize_ids_after_copy(ids=ids,forced=0,REQUEST=REQUEST)

      # Sort order (II).
      self.normalizeSortIds()
      
      # Return with message.
      if RESPONSE is not None:
        message = self.getLangStr('MSG_PASTED',REQUEST['manage_lang'])
        RESPONSE.redirect('manage_main?lang=%s&manage_lang=%s&manage_tabs_message=%s'%(REQUEST['lang'],REQUEST['manage_lang'],urllib.quote(message)))

###################################################################################################
