###################################################################################################
# _pathhandler.py
#
# $Id: _pathhandler.py,v 1.6 2004/11/24 21:02:52 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.6 $
#
# Implementation of class PathHandler (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
import copy
# Product Imports.
import _blobfields
import _globals


###################################################################################################
###################################################################################################
###
###   class PathHandler:
###
###   Based on the Zope-Product PathHandler (http://www.zope.org/Members/NIP/PathHandler).
###
###################################################################################################
###################################################################################################
class PathHandler: 
        
    # ------------------------------------------------------------------------------------------
    #  PathHandler.__bobo_traverse__
    # ------------------------------------------------------------------------------------------
    def __bobo_traverse__(self, TraversalRequest, name):
      # If this is the first time this __bob_traverse__ method has been called
      # in handling this traversal request, store the path_to_handle
      
      if not TraversalRequest.has_key('path_to_handle'):
      
          # Make a reversed copy of the TraversalRequestNameStack
          TraversalRequestNameStackReversed=copy.copy(TraversalRequest['TraversalRequestNameStack'])
          TraversalRequestNameStackReversed.reverse()
          
          # Set path_to_handle in the TraversalRequest.
          TraversalRequest['path_to_handle']=[name]+TraversalRequestNameStackReversed
     
      # If the name is in the list of attributes, call it.
      ob = getattr( self, name, None)
      if ob is None:
        obs = self.objectValues( self.dGlobalAttrs.keys())
        filtered_obs = filter( lambda x: x.getDeclId( self.REQUEST) == name and x.isPage(), obs)
        if len( filtered_obs) == 1:
          ob = filtered_obs[0]
      if ob is not None:
        if getattr(ob,'meta_type',None) in self.dGlobalAttrs.keys():
          if self.REQUEST.get('URL','').find('/manage') < 0 and \
             TraversalRequest['path_to_handle'][-1] == name:
            ob = _globals.getPageWithElements( ob, self.REQUEST)
        # if _globals.debug( self):
        #   _globals.writeLog( self, "[PathHandler.__bobo_traverse__]: %s"%self.REQUEST['URL'])

        return ob
      
      # otherwise do some 'magic'
      else:

        if self.REQUEST.get('URL','').find('/manage') < 0:

          thisOb = self
          obs = self.objectValues( self.dGlobalAttrs.keys())
          filtered_obs = filter( lambda x: x.getDeclId( self.REQUEST) == name and x.isPage(), obs)
          if len( filtered_obs) == 1:
            thisOb = filtered_obs[0]

          # Recursive inclusions.
          if thisOb.meta_type == 'ZMSLinkElement':
            recursive = thisOb.isEmbeddedRecursive( self.REQUEST)
            if recursive:
              ob = thisOb.getRefObj( )
              proxy = thisOb.initProxy( thisOb.aq_parent, thisOb.absolute_url(), ob, recursive)
              c = 0
              l = TraversalRequest[ 'path_to_handle']
              i = l.index( thisOb.getDeclId( self.REQUEST)) + 1
              for k in range( i, len(l)):
                newOb = None
                obs = ob.getChildNodes( self.REQUEST, self.PAGES)
                filtered_obs = filter( lambda x: x.getDeclId( self.REQUEST) == l[k], obs)
                if len( filtered_obs) == 1:
                  newOb = filtered_obs[0]
                try:
                  if newOb.meta_type not in self.dGlobalAttrs.keys():
                    newOb = None
                except:
                  pass
                if newOb is None:
                  break
                ob = newOb
                proxy = thisOb.initProxy( proxy, proxy.absolute_url()+'/'+ob.id, ob, recursive)
                c += 1
              if c > 0:
                self.REQUEST.set( 'ZMS_PROXY', proxy)
            return thisOb

        # Declarative Urls.
        lang = self.getPrimaryLanguage()
        index = TraversalRequest['path_to_handle'][-1]
        i = index.rfind('_')
        j = index.rfind('.')
        if i > 0 and i < j:
          lang = index[i+1:j]
          if lang in self.getLangIds():
            self.REQUEST.set('lang',lang)
        ob = self.pathob([name],self.REQUEST)
        if ob is not None:
          if getattr(ob,'meta_type',None) in self.dGlobalAttrs.keys():
            if self.REQUEST.get('URL','').find('/manage') < 0 and name == TraversalRequest['path_to_handle'][-1]:
              ob = _globals.getPageWithElements( ob, self.REQUEST)
          # if _globals.debug( self):
          #   _globals.writeLog( self, "[PathHandler.__bobo_traverse__]: %s"%self.REQUEST['URL'])
          return ob
        
        # If the object is record-set and has blob-fields find by filename and display data.
        if name.find( '@') == 0 and \
           self.meta_type == 'ZMSCustom' and \
           self.getType()=='ZMSRecordSet':
          try:
            i = int( name[1:])
            r = self.getObjProperty( self.getMetaobj( self.meta_id)['attrs'][0]['id'], self.REQUEST)
            d = r[i]
            for key in d.keys():
              value = d[key]
              if value is not None and hasattr(value,'__class__') and (getattr(value,'__class__') is _blobfields.MyImage or getattr(value,'__class__') is _blobfields.MyFile):
                value = value._getCopy()
                value.aq_parent = self
                value.key = key
                value.lang = self.getPrimaryLanguage()
                langfilename = value.getHref( self.REQUEST).split( '/')[ -1]
                if langfilename.find( '?') > 0:
                  langfilename = langfilename[ :langfilename.find( '?')]
                if langfilename == TraversalRequest['path_to_handle'][-1]:
                  return value
          except:
            _globals.writeException( self)
        
        # If the object has resource-fields of special-object find by filename and display data.
        if self.meta_type == 'ZMSCustom':
          for key in self.getMetaobjAttrIds( self.meta_id):
             metaObjAttr = self.getMetaobjAttr( self.meta_id, key)
             if metaObjAttr['type'] == 'resource':
                value = metaObjAttr.get('custom',None)
                if value is not None:
                  value = value._getCopy()
                  value.aq_parent = self
                  value.key = key
                  value.lang = self.getPrimaryLanguage()
                  langfilename = value.getHref( self.REQUEST).split( '/')[ -1]
                  if langfilename.find( '?') > 0:
                    langfilename = langfilename[ :langfilename.find( '?')]
                  if langfilename == name:
                    return value
        
        # If the object has blob-fields find by filename and display data.
        for key in self.getObjAttrs().keys():
          obj_attr = self.getObjAttr(key)
          datatype = obj_attr['datatype_key']
          if datatype in _globals.DT_BLOBS:
            value = self.getObjProperty( key, self.REQUEST)
            if value is not None:
              langfilename = value.getHref( self.REQUEST).split( '/')[ -1]
              if langfilename.find( '?') > 0:
                langfilename = langfilename[ :langfilename.find( '?')]
              if langfilename == name:
                return value
        
        # If the object has moved diplay the new location.
        try:
          obj_id = TraversalRequest['path_to_handle'][-1]
          obj_ids = [obj_id]
          obj_metatypes = ['ZMS','ZMSRubrik','ZMSDocument','ZMSCustom','ZMSSysFolder','ZMSFile'] # self.dGlobalAttrs.keys()
          zcat = self.getCatalog()
          this = self.getHome()
          results = this.PrincipiaFind(this, 
             obj_ids=obj_ids, 
             obj_metatypes=obj_metatypes, 
             obj_searchterm=None, 
             obj_expr=None, 
             obj_mtime=None, 
             obj_mspec=None, 
             obj_permission=None, 
             obj_roles=None, 
             search_sub=1, 
             REQUEST=self.REQUEST)
          if len(results) > 0:
            path = results[0][0]
            eErr = "Resource moved",'<h2>Site-Error</h2><b>Sorry, the web page you requested has moved.</b> You will find it in a new location: <a href="' + this.absolute_url() + '/' + path + '">' + path + '<hr><b>Resource<b> <i>'+obj_id+'</i> '+''.join(map(lambda x: x+'/',TraversalRequest['path_to_handle']))+' GET'
            self.REQUEST.RESPONSE.redirect( this.absolute_url() + '/' + path, status=301 )
            return self
        except:
          pass
        
        # If there's no more names left to handle, return the path handling method
        # to the traversal machinery so it gets called next
	raise "Resource not found",'<h2>Site-Error</h2><b>Sorry, there is no web page matching your request.</b> It is possible you typed the address incorrectly, or that the page no longer exists.<hr><b>Resource<b> <i>'+name+'</i> '+''.join(map(lambda x: x+'/',TraversalRequest['path_to_handle']))+' GET'


    # ------------------------------------------------------------------------------------------
    #  PathHandler.pathob
    # ------------------------------------------------------------------------------------------
    def pathob(self, path_to_handle, REQUEST):
      langs = self.getLangIds()
      path_ob = self
      path_index = 0
      while True:
        if path_index == len(path_to_handle):
          return path_ob
        path_item = path_to_handle[path_index].lower()
        if path_index == 0 and path_item in langs:
          REQUEST.set('lang',path_item)
        else:
          obs = path_ob.getChildNodes( REQUEST ,self.PAGES)
          path_ob = None
          for ob in obs:
            if path_item == ob.id or \
               path_item == ob.getDeclId( REQUEST):
              path_ob = ob
          if path_ob is None: 
            break
        path_index = path_index + 1
      return None

###################################################################################################
