# stuff that didn't fit in CMF.py or __init__.py

from types import *
import string, re, os
from AccessControl import getSecurityManager
from DateTime import DateTime
from Globals import package_home
from ZWikiPage import ZWikiPage
from CMF import WikiFolder
import Permissions
from Defaults import PAGE_METATYPE, PAGE_PORTALTYPE, \
     WIKI_METATYPE, WIKI_PORTALTYPE, DEFAULT_PAGE_TYPE
from ZWikiWeb import _addDTMLMethod, _addZWikiPage

wiki_globals=globals()

default_perms = {
    'create': 'nonanon',
    'edit': 'nonanon',
    'comment': 'nonanon',
    'move': 'owners', # rename/delete/reparent
    'regulate': 'owners'
    }

def initPageMetadata(page):
    page.creation_date = DateTime()
    page._editMetadata(title='',
                       subject=(),
                       description='',
                       contributors=(),
                       effective_date=None,
                       expiration_date=None,
                       format='text_html',
                       language='',
                       rights = '')

def makeWikiPage(id, title, file):
    ob = ZWikiPage(source_string=file, __name__=id)
    ob.title = title
    ob.parents = []
    username = getSecurityManager().getUser().getUserName()
    ob.manage_addLocalRoles(username, ['Owner'])
    ob._getRegs().setSubOwner('both')
    initPageMetadata(ob)
    #XXX sets up default permissions/regulations
    #for name, perm in ob._perms.items():
    #    pseudoperm = default_perms[name]
    #    local_roles_map = ob._local_roles_map
    #    roles_map = ob._roles_map
    #    roles = (local_roles_map[name],) + roles_map[pseudoperm]
    #    ob.manage_permission(perm, roles=roles)
    return ob

def addWikiPage(self, id, title='', page_type=None, file=''):
    id=str(id)
    title=str(title)
    ob = makeWikiPage(id, title, file)
    ob.page_type = page_type or \
                   getattr(self,'standard_page_type',DEFAULT_PAGE_TYPE)
    self._setObject(id, ob)

def addWikiFolder(self, id, title=''):
    id = str(id)
    title = str(title)
    ob = WikiFolder(id, title)
    id = self._setObject(id, ob)
    ob = getattr(self, id)
    # duplicated from ZWikiWeb.py for now
    dir = package_home(globals()) + os.sep + 'content/basic'
    filenames = os.listdir(dir)
    for filename in filenames:
        if (filename[-5:] == '.dtml'
            and not filename == 'standard_error_message.dtml'):
            text = open(dir + os.sep + filename, 'r').read()
            _addDTMLMethod(ob, filename[:-5], title='', file=text)
        else:
            m = re.search(r'(.+)\.(.+)',filename)
            if m:
                text = open(dir + os.sep + filename, 'r').read()
                name, type = m.group(1), m.group(2)
                p = _addZWikiPage(ob,name,title='',page_type=type,file=text)
                initPageMetadata(p)

factory_type_information = (
    {'id': PAGE_PORTALTYPE,
     'content_icon': 'wikipage_icon.gif',
     'meta_type': PAGE_METATYPE,
     'product': 'ZWiki',
     'factory': 'addWikiPage',
     'immediate_view': 'wikipage_view',
     'actions': ({'id': 'view',
                  'name': 'View',
                  'action': 'wikipage_view',
                  'permissions': (Permissions.View,)},
                 {'id': 'edit',
                  'name': 'Edit',
                  'action': 'editform',
                  'permissions': (Permissions.Edit,)},
                 {'id': 'history',
                  'name': 'History',
                  'action': 'diff',
                  'permissions': (Permissions.View,)},
                 {'id': 'backlinks',
                  'name': 'Backlinks',
                  'action': 'backlinks',
                  'permissions': (Permissions.View,)},
                 {'id': 'subscribe',
                  'name': 'Subscribe',
                  'action': 'subscribeform',
                  'permissions': (Permissions.View,)},
#                 {'id': 'advanced',
#                  'name': 'Advanced',
#                  'action': 'wikipage_advanced_form',
#                  'permissions': (Permissions.View,)},
                 ),
     },
    {'id': WIKI_PORTALTYPE,
     'content_icon': 'folder_icon.gif',
     'meta_type': WIKI_METATYPE,
     'description': ('A wiki. A set of editable pages with flexible organization.'),
     'product': 'ZWiki',
     'factory': 'addWikiFolder',
     'immediate_view': 'wikifolder_edit_form',
     'actions': (#{'id': 'toc',
                 # 'name': 'Wiki Contents',
                 # 'category': 'folder',
                 # 'action':'wiki_toc',
                 # 'permissions': (Permissions.View,)},
                 {'id': 'view',
                  'name': 'View',
                  'category': 'object',
                  'action':'index_html',
                  'permissions': (Permissions.View,)},
                 {'id': 'edit',
                  'name': 'Edit',
                  'category': 'object',
                  'action':'wikifolder_edit_form',
                  'permissions': (Permissions.Edit,)},
                 #{'id': 'all',
                 # 'name': 'All Pages',
                 # 'category': 'folder',
                 # 'action':'wiki_allpages',
                 # 'permissions': (Permissions.View,)},
                 #{'id': 'recent_changes',
                 # 'name': 'Recent Changes',
                 # 'category': 'folder',
                 # 'action':'wiki_recentchanges',
                 # 'permissions': (Permissions.View,)},
                 #{'id': 'wikihelp',
                 # 'name': 'WikiHelp',
                 # 'category': 'folder',
                 # 'action': 'WikiHelp',
                 # 'permissions': (Permissions.View,)}
                 ),
     },
    )

from Products.CMFCore import utils
from Products.CMFCore.DirectoryView import registerDirectory
from Products.CMFCore.PortalFolder import PortalFolder
from Permissions import Create

def initialize(context): 
    """Initialize the ZWiki product for use in CMF.
    """
    registerDirectory('skins', globals())
    utils.ContentInit(
        'Wiki Content',
        content_types = (ZWikiPage, PortalFolder),
        permission = Create,
        extra_constructors = (addWikiPage, addWikiFolder),
        fti = factory_type_information,
        ).initialize(context)
