/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: base64.c,v 1.16.2.4 2003/10/16 21:03:45 bazsi Exp $
 *
 *
 * Author  : SaSa
 * Auditor :
 * Last audited version:
 * Notes:
 *
 ***************************************************************************/

#include <zorp/code.h>
#include <zorp/zorp.h>
#include <zorp/log.h>

typedef struct _ZCodeBase64
{
  ZCode super;
  char buf[3];
  guint len;
  guint err;
} ZCodeBase64;

static gint
z_code_base64_translate_char(guchar c)
{
  static const char base64_alphabet[128] =
    {
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,     /*  0 */
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,     /* 16 */
      -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63,     /* 32 */
      52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1,     /* 48 */
      -1,  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14,     /* 64 */
      15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1,     /* 80 */
      -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,     /* 96 */
      41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1      /*112 */
    };

  z_enter();

  if (c == '=')
    {
      z_leave();
      return -2;
    }
  else if (c > 127)
    {
      z_leave();
      return -1;
    }
  else
    {
      z_leave();
      return base64_alphabet[c];
    }
  z_leave();
}
                                                                                                          

static guint
z_code_base64_convert_quattro(ZCodeBase64 *self,
                                    gchar *to,
                                    guint  tolen,
                                    gchar *from)
{
  gchar c[4];
  guint len;
  guint i, j;
  
  z_enter();
  c[0] = z_code_base64_translate_char(from[0]);
  c[1] = z_code_base64_translate_char(from[1]);
  c[2] = z_code_base64_translate_char(from[2]);
  c[3] = z_code_base64_translate_char(from[3]);

  len = 3;

  /* sanity check quantum */

  for (i = 0; i < 4; i++)
    if (c[i] == -2)
      {
        c[i] = 0;
        if (i == 2)
          len = 1;
        else if (i == 3)
          len = 2;
        else
          {
            z_leave();
            return 0;
          }

        for (j = i + 1; j < 4; j++)
          {
            if (c[j] != -2)
              {
                z_leave();
                return 0;
              }
            c[j] = 0;
          }
      }
    else if (c[i] == -1)
      {
        z_leave();
        return 0;
      }

  if (len > tolen)
    self->err = TRUE;

  if (len < 1 || tolen < 1)
    {
      z_leave();
      return len;
    }

  *to = (c[0] << 2) | ((c[1] & 0x30) >> 4);
  to++;

  if (len < 2 || tolen < 2)
    {
      z_leave();
      return len;
    }

  *to = ((c[1] & 0x0f) << 4) | ((c[2] & 0x3e) >> 2);
  to++;

  if (len < 3 || tolen < 3)
    {
      z_leave();
      return len;
    }

  *to = ((c[2] & 0x03) << 6) | (c[3] & 0x3f);

  z_leave();
  return len;
}

static gboolean
z_code_base64_decode(ZCode *code,
                     gchar *from,
                     guint  fromlen,
                     gchar *to,
                     guint *tolen)
{
  ZCodeBase64 *self = (ZCodeBase64 *)code;
  char tmp[4];
  guint len, i, j, frompos, cikl, topos = 0;

  z_enter();
  
  if (code->type != Z_CODE_BASE64)
    {
      z_leave();
      return FALSE;
    }

  if (self->err)
    {
      z_leave();
      return FALSE;
    }
  
  for (i = 0; i < self->len; i++)
    {
      tmp[i] = self->buf[i];
    }
  
  frompos = 0;
  
  cikl = (fromlen + i) % 4;
  len = 1;
  
  while (cikl && len && topos < *tolen - 1)
    {
      for (j = i; j < 4; j++)
        {
          tmp[i] = from[frompos];
          frompos++;
        }
      len = z_code_base64_convert_quattro(self, &to[topos], *tolen - topos - 1, tmp);
      topos += len;
      i = 0;
      cikl--;
    }
    
  if (len == 0)
    {
      self->err = TRUE;
      z_leave();
      return FALSE;
    }

  j = fromlen - frompos;
  if (j > 3)
    {
      self->err = TRUE;
      z_leave();
      return FALSE;
    }
    
  for (i = 0; i < j; i++)
    {
      self->buf[i] = from[frompos];
      frompos++;
    }

  to[topos] = 0;
  *tolen = topos;
  z_leave();
  return TRUE;
}

ZCode *
z_code_base64_new(void)
{
  ZCodeBase64 *self;
  
  z_enter();
  self = g_new0(ZCodeBase64, 1);
  
  self->super.type = Z_CODE_BASE64;
  self->super.decode = z_code_base64_decode;
  /* FIXMEE */
  self->super.encode = NULL;
  z_leave();
  return &self->super;
}
