/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: pycore.c,v 1.2.4.3 2003/04/26 13:48:06 sasa Exp $
 *
 * Author  : Bazsi
 * Auditor : kisza
 * Last audited version: 1.22
 * Notes:
 *
 ***************************************************************************/

/* 
 * this module implements the interface with python 
 */
#include <zorp/pycore.h>
#include <zorp/log.h>
#include <zorp/io.h>
#include <zorp/policy.h>
#include <zorp/sysdep.h>
#include <zorp/streamfd.h>

#include <zorp/pystream.h>

#include <netdb.h>

PyObject *PyExc_LicenseException;

/* exported python methods */

/*+

  Called by Python to send a message to the event log. Declaration
  in Python would be:

    def z_py_log(verbosity, priority, msg)

  Parameters:
    self       unused, required by Python calling mechanism
    args       arguments tuple

  Returns:
    PyNone

  +*/
static PyObject *
z_py_log(PyObject *self G_GNUC_UNUSED, PyObject *args)
{
  unsigned long verbosity;
  char *class, *msg;
  PyObject *py_session_id;
  gchar *session_id;

  if (!PyTuple_Check(args))
    {
      PyErr_SetString(PyExc_TypeError, "args must be a tuple");
      return NULL;
    }
  if (PyTuple_Size(args) == 3)
    {
      if (!PyArg_ParseTuple(args, "sis", &class, &verbosity, &msg))
        return NULL;
      session_id = NULL;
    }
  else
    {  
      if (!PyArg_ParseTuple(args, "Osis", &py_session_id, &class, &verbosity, &msg))
        return NULL;
      if (py_session_id == Py_None)
        {
          session_id = NULL;
        }
      else if (PyString_Check(py_session_id))
        {
          session_id = PyString_AsString(py_session_id);
        }
      else
        {
          PyErr_SetString(PyExc_TypeError, "Session ID must be string or None");          return NULL;
        }


    }
    
  /*NOLOG*/
  z_log(session_id, class, verbosity, "%s", msg);
  Py_XINCREF(Py_None);
  return Py_None;
}
 
/*+
  +*/

static PyObject *
z_py_quit(PyObject *self G_GNUC_UNUSED, PyObject *args)
{
  int exit_code;
  
  z_enter();
  if (!PyArg_ParseTuple(args, "i", &exit_code))
    {
      z_leave();
      return NULL;
    }
  z_main_quit(exit_code);
  Py_XINCREF(Py_None);
  z_leave();
  return Py_None;
}

static PyObject *
z_py_stream_pair(PyObject *self G_GNUC_UNUSED, PyObject *args)
{
  int domain, type, proto = 0;
  int result[2];
  ZStream *streams[2];
  PyObject *pystreams[2];
  
  z_enter();
  if (!PyArg_ParseTuple(args, "ii|i", &domain, &type, &proto))
    {
      z_leave();
      return NULL;
    }
  if (socketpair(domain, type, proto, result) == -1)
    {
      PyErr_SetString(PyExc_IOError, "I/O error during socketpair.");
      z_leave();
      return NULL;
    }

  streams[0] = z_stream_new(result[0], "streamPair/A");
  streams[1] = z_stream_new(result[1], "streamPair/B");

  pystreams[0] = z_py_stream_new(streams[0]);
  pystreams[1] = z_py_stream_new(streams[1]);

  z_stream_unref(streams[0]);
  z_stream_unref(streams[1]);
  
  z_leave();
  return z_policy_var_build("(OO)", pystreams[0], pystreams[1]);
}

static PyObject *
z_py_get_instance_id(PyObject *self G_GNUC_UNUSED, PyObject *args)
{
  static GHashTable *instance_ids = NULL;
  gint *value;
  gchar *service_name;
  
  if (!PyArg_Parse(args, "(s)", &service_name))
    return NULL;
  if (instance_ids == NULL)
    instance_ids = g_hash_table_new(g_str_hash, g_str_equal);
  
  value = g_hash_table_lookup(instance_ids, service_name);
  
  if (!value)
    {
      value = g_new(gint, 1);
      *value = 0;
      g_hash_table_insert(instance_ids, g_strdup(service_name), value);
    }
  else
    {
      (*value)++;
    }
  return PyInt_FromLong(*value);
}

static PyMethodDef zorp_funcs[] = 
{
  { "log", z_py_log, METH_VARARGS, NULL },
  { "quit", z_py_quit, METH_VARARGS, NULL },
  { "streamPair", z_py_stream_pair, METH_VARARGS, NULL },
  { "getInstanceId", z_py_get_instance_id, METH_VARARGS, NULL },
  { NULL, NULL, 0, NULL }
};

void
z_py_zorp_core_init(void)
{
  Py_InitModule("Zorp.Zorp", zorp_funcs);
}

