/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: pyszig.c,v 1.3.2.1 2004/02/03 09:16:28 sasa Exp $
 *
 * Author  : bazsi
 * Auditor : kisza
 * Last audited version: 1.4
 * Notes:
 *
 ***************************************************************************/

/* Simple Zorp Information Gathering */

#include <zorp/pyszig.h>
#include <zorp/zorp.h>

#include <zorp/log.h>

static PyObject *
z_py_zorp_szig_format(ZorpSZIG *self G_GNUC_UNUSED)
{
  return PyString_FromString("Simple Zorp Information Gathering");
}

static PyMethodDef py_zorp_szig_methods[] =
{
  { "format",      (PyCFunction) z_py_zorp_szig_format, 0, NULL },
  { NULL,          NULL, 0, NULL }   /* sentinel*/
};

static PyObject *
z_py_zorp_szig_get(PyObject *self G_GNUC_UNUSED, PyObject *args)
{
  gchar *name;
  GValue *value;
  PyObject *ret;
  
  z_enter();
  if (!PyArg_ParseTuple(args, "s", &name))
    {
      z_leave();
      return NULL;
    }
  
  value = z_szig_get_value(name);
  
  switch (G_VALUE_TYPE(value))
    {
    case G_TYPE_LONG:
      ret = Py_BuildValue("i", g_value_get_long(value));
      break;
    case G_TYPE_FLOAT:
      ret = Py_BuildValue("f", g_value_get_long(value));
      break;
    case G_TYPE_STRING:
      ret = Py_BuildValue("s", g_value_get_string(value));
      break;
    case G_TYPE_BOOLEAN:
      ret = Py_BuildValue("i", g_value_get_boolean(value));
      break;
    default:
      z_leave();
      return NULL;
    }
  
  return ret;
}

static PyObject *
z_py_zorp_szig_set(PyObject *self G_GNUC_UNUSED, PyObject *args)
{
  gchar *name;
  GValue *value;
  PyObject *value_obj;
  
  z_enter();
  if (!PyArg_ParseTuple(args, "(sO)", &name, &value_obj))
    {
      z_leave();
      return NULL;
    }
  
  value = g_new0(GValue, 1);
                    
  if (PyInt_Check(value_obj))
    {
      value = g_value_init(value, G_TYPE_LONG);
      g_value_set_long(value, PyInt_AsLong(value_obj));
    }
  else if (PyFloat_Check(value_obj))
    {
      value = g_value_init(value, G_TYPE_FLOAT);
      g_value_set_float(value, PyFloat_AsDouble(value_obj));
    }
  else if (PyString_Check(value_obj))
    {
      value = g_value_init(value, G_TYPE_STRING);
      g_value_set_string(value, PyString_AsString(value_obj));
    }
  else
    {
      z_leave();
      return NULL;
    }
  
  if (z_szig_set(name, value))
    {
      Py_XINCREF(Py_None);
      z_leave();
      return Py_None;
    }
  z_leave();
  return NULL;
}

static PyObject *
z_py_zorp_szig_add(PyObject *self G_GNUC_UNUSED, PyObject *args)
{
  gchar *name;
  GValue *value;
  PyObject *value_obj;
  
  z_enter();
  if (!PyArg_ParseTuple(args, "(sO)", &name, &value_obj))
    {
      z_leave();
      return NULL;
    }
  
  value = g_new0(GValue, 1);
                    
  if (PyInt_Check(value_obj))
    {
      value = g_value_init(value, G_TYPE_LONG);
      g_value_set_long(value, PyInt_AsLong(value_obj));
    }
  else if (PyFloat_Check(value_obj))
    {
      value = g_value_init(value, G_TYPE_FLOAT);
      g_value_set_float(value, PyFloat_AsDouble(value_obj));
    }
  else if (PyString_Check(value_obj))
    {
      value = g_value_init(value, G_TYPE_STRING);
      g_value_set_string(value, PyString_AsString(value_obj));
    }
  else
    {
      z_leave();
      return NULL;
    }
  
  if (z_szig_add(name, value))
    {
      Py_XINCREF(Py_None);
      z_leave();
      return Py_None;
    }
  z_leave();
  return NULL;
}

static PyObject *
z_py_zorp_szig_sub(PyObject *self G_GNUC_UNUSED, PyObject *args)
{
  gchar *name;
  GValue *value;
  PyObject *value_obj;
  
  z_enter();
  if (!PyArg_ParseTuple(args, "(sO)", &name, &value_obj))
    {
      z_leave();
      return NULL;
    }
  
  value = g_new0(GValue, 1);
                    
  if (PyInt_Check(value_obj))
    {
      value = g_value_init(value, G_TYPE_LONG);
      g_value_set_long(value, PyInt_AsLong(value_obj));
    }
  else if (PyFloat_Check(value_obj))
    {
      value = g_value_init(value, G_TYPE_FLOAT);
      g_value_set_float(value, PyFloat_AsDouble(value_obj));
    }
  else if (PyString_Check(value_obj))
    {
      value = g_value_init(value, G_TYPE_STRING);
      g_value_set_string(value, PyString_AsString(value_obj));
    }
  else
    {
      z_leave();
      return NULL;
    }
  
  if (z_szig_sub(name, value))
    {
      Py_XINCREF(Py_None);
      z_leave();
      return Py_None;
    }
  z_leave();
  return NULL;
}

static PyObject *
z_py_zorp_szig_lock(PyObject *self G_GNUC_UNUSED, PyObject *args G_GNUC_UNUSED)
{
  Py_XINCREF(Py_None);
  return Py_None;
}

static PyObject *
z_py_zorp_szig_unlock(PyObject *self G_GNUC_UNUSED, PyObject *args G_GNUC_UNUSED)
{
  Py_XINCREF(Py_None);
  return Py_None;
}

PyMethodDef z_py_zorp_szig_funcs[] =
{
  { "get",    z_py_zorp_szig_get,    METH_VARARGS, NULL },
  { "set",    z_py_zorp_szig_set,    METH_VARARGS, NULL },
  { "add",    z_py_zorp_szig_add,    METH_VARARGS, NULL },
  { "sub",    z_py_zorp_szig_sub,    METH_VARARGS, NULL },
  { "lock",   z_py_zorp_szig_lock,   METH_VARARGS, NULL },
  { "unlock", z_py_zorp_szig_unlock, METH_VARARGS, NULL },
  { NULL,            NULL, 0, NULL }   /* sentinel*/
};

static gint
z_py_zorp_szig_setattr(PyObject *o G_GNUC_UNUSED,
                           char *name G_GNUC_UNUSED,
                       PyObject *value G_GNUC_UNUSED)
{
  return 0;
}

static PyObject *
z_py_zorp_szig_getattr(PyObject *o, char *name)
{
  return Py_FindMethod(py_zorp_szig_methods, o, name);
}

PyTypeObject z_py_zorp_szig_type =
{
  PyObject_HEAD_INIT(&PyType_Type)
  0,                                        /*ob_size*/
  "ZorpSZIG",                               /*tp_name*/
  sizeof(ZorpSZIG),                         /*tp_basicsize*/
  0,                                        /*tp_itemsize*/
  /* methods */
  (destructor)0,                            /*tp_dealloc*/
  (printfunc)0,                             /*tp_print*/
  (getattrfunc)z_py_zorp_szig_getattr,      /*tp_getattr*/
  (setattrfunc)z_py_zorp_szig_setattr,      /*tp_setattr*/
  (cmpfunc)0,                               /*tp_compare*/
  (reprfunc)0,                              /*tp_repr*/
  0,                                        /*tp_as_number*/
  0,                   		            /*tp_as_sequence*/
  0,                   		            /*tp_as_mapping*/
  (hashfunc)0,         		            /*tp_hash*/
  (ternaryfunc)0,      		            /*tp_call*/
  (reprfunc)z_py_zorp_szig_format,          /*tp_str*/

  /* Space for future expansion */
  0L,0L,0L,0L,
  "ZorpSockAddr class", /* Documentation string */
  0, 0, 0, 0
};

void
z_py_zorp_szig_init(void)
{
  Py_InitModule("Zorp.SZIG", z_py_zorp_szig_funcs);
}
