/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: zorp.c,v 1.9.2.9 2004/02/03 09:16:28 sasa Exp $
 *
 * Author  : Bazsi
 * Auditor :
 * Last audited version:
 * Notes:
 *
 ***************************************************************************/

#include <zorp/zpython.h>
#include <zorp/zorp.h>
#include <zorp/log.h>

#include <zorp/policy.h>

GMainLoop *main_loop;
gint exit_code = 0;

void
z_main_quit(int rc)
{
  z_enter();
  exit_code = rc;
  g_main_quit(main_loop);
  z_leave();
}

void
z_log_set_fake_session_id(gchar *instance_name G_GNUC_UNUSED)
{
  PyObject *z, *name;
  
  z_policy_acquire_main(current_policy);
  z = PyImport_AddModule("Zorp.Zorp");
  name = PyObject_GetAttrString(z, "firewall_name");
  if (name && PyString_Check(name))
    {
      g_snprintf(fake_session_id, sizeof(fake_session_id), "%s@%s/nosession", instance_name, PyString_AsString(name));
    }
  else
    {
      strcpy(fake_session_id, "noname/nosession");
    }
  Py_XDECREF(name);
  z_policy_release_main(current_policy);
}
