/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: fastpath.h,v 1.1.2.3 2003/04/28 13:57:31 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_FASTPATH_H_INCLUDED
#define ZORP_FASTPATH_H_INCLUDED

#include <zorp/sockaddr.h>
#include <zorp/stream.h>
#include <zorp/connection.h>

typedef struct _ZProxyFastpathSession
{
  ZSockAddr *client_address;
  ZSockAddr *client_local;
  ZSockAddr *server_address;
  ZSockAddr *server_local;
} ZProxyFastpathSession;

typedef struct _ZProxyFastpath
{
  gpointer router_data; 
  void (*router)(ZProxyFastpathSession *conn, gpointer data);
  void (*router_free)(gpointer data);

  gpointer chainer_data;
  ZStream *(*chainer)(ZProxyFastpathSession *conn, gpointer data);
  void (*chainer_free)(gpointer data);

  gpointer snat_data;
  void (*snat)(ZProxyFastpathSession *conn, gpointer data);
  void (*snat_free)(gpointer data);

  gpointer dnat_data;
  void (*dnat)(ZProxyFastpathSession *conn, gpointer data);  
  void (*dnat_free)(gpointer data);
} ZProxyFastpath;


void z_proxy_fastpath_session_destroy(ZProxyFastpathSession *self);
void z_proxy_fastpath_destroy(ZProxyFastpath *self);

struct _ZProxy;

ZStream *
z_proxy_fastpath_connect_server_event(struct _ZProxy *proxy, ZConnection *conn);


#endif
