/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: plugsession.h,v 1.2.2.4 2004/02/03 09:16:28 sasa Exp $
 *
 ***************************************************************************/
#ifndef ZORP_PLUGSESSION_H_INCLUDED
#define ZORP_PLUGSESSION_H_INCLUDED

#include <zorp/proxy.h>
#include <zorp/zorp.h>
#include <zorp/poll.h>

typedef struct _ZPlugSession ZPlugSession;
typedef gboolean (*ZPlugSessionStatsFunc)(ZProxy *proxy, ZSessionVars *vars, 
					  guint64 client_bytes, guint64 client_pkts, 
					  guint64 server_bytes, guint64 server_pkts);

typedef struct _ZPlugSessionData
{
  guint num_sessions;
  GList *destroy_queue;

  gint timeout;
  gboolean copy_to_server, copy_to_client;
  gboolean shutdown_soft;
  guint buffer_size;
  guint packet_stats_interval_time, packet_stats_interval_packet;
  ZPlugSessionStatsFunc packet_stats;
} ZPlugSessionData;

gboolean
z_plug_session_start(ZPlugSession *self, ZPoll *poll);

ZPlugSession *
z_plug_session_new(ZProxy *owner, 
                   ZPlugSessionData *session_data, 
                   ZStream *client_stream, 
                   ZStream *server_stream, 
                   ZStackedProxy *stacked);

void
z_plug_session_free(ZPlugSession *self);

static inline gboolean
z_plug_sessions_running(ZPlugSessionData *session_data)
{
  return session_data->num_sessions > 0;
}

void
z_plug_sessions_purge(ZPlugSessionData *session_data);

#endif
