############################################################################
##
## Copyright (c) 2000, 2001, 2002 BalaBit IT Ltd, Budapest, Hungary
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##
## $Id: Listener.py,v 1.62.2.10 2003/09/25 08:36:24 bazsi Exp $
##
## Author  : Bazsi
## Auditor : kisza
## Last audited version: 1.15
## Notes:
##
############################################################################

"""Module implementing Listeners.

This module defines the Listener class, the main entry point for client
requests. Listener binds to a given address, waits for connections, and for
each connection spawns a new session to handle it.
"""

from Dispatch import *

class Listener(Dispatcher):
        """Class encapsulating a Listener, which starts services for established connections.
        
        This class is the starting point of Zorp services. It listens on the
        given port, and when a connection is accepted it starts a session
        and the given service.
        """
	def __init__(self, bindto, service, **kw):
                """Constructor to initialize a Listen instance
                
                Creates the instance, sets the initial attributes, and
                starts the listener

                Arguments

                  self -- this instance
                  
                  bindto --  [SOCKADDR] the address to bind to
                  
                  service -- [STRING_service] the service name to start
                  
                  transparent -- [BOOLEAN] TRUE if this is a listener of a 
                                 transparent service, specifying this is
                                 not mandatory but performs additional checks

                  backlog -- [INTEGER] backlog value to pass to listen()
                  
                """
		Dispatcher.__init__(self, ZD_PROTO_TCP, bindto, service, kw=kw)

class ZoneListener(ZoneDispatcher):
	def __init__(self, bindto, services, **kw):
		"""Constructor to initialize a ZoneListener instance.
		
		This constructor initializes a ZoneListener instance and sets
		its initial attributes based on arguments.
		
		Arguments
		 
		  self -- this instance
		  
		  bindto -- [SOCKADDR] bind to this address
		  
		  services -- [HASH;STRING_zone;STRING_service] a mapping between zone names and services
		  
		  transparent -- [BOOLEAN] TRUE if this is a listener of a 
                                 transparent service, specifying this is
                                 not mandatory but performs additional checks
                                 
                  backlog -- [INTEGER] backlog value to pass to listen()


		  follow_parent -- [BOOLEAN] If set child zones inherit service set.

		"""
		ZoneDispatcher.__init__(self, ZD_PROTO_TCP, bindto, services, kw=kw)

class CSZoneListener(CSZoneDispatcher):
	"""Class to listen on the selected address, and start a service based on the client's and the original server zone.
	
	This class is similar to a simple Listener, but instead of
	starting a fixed service, it chooses one based on the client
	and the destined server zone.
	
	It takes a mapping of services indexed by a client and the server
	zone name, with an exception of the '*' zone, which matches
	anything.

	NOTE: the server zone might change during proxy and NAT processing,
	therefore the server zone used here only matches the real
	destination if those phases leave the server address intact.
	"""
	
	def __init__(self, bindto, services, **kw):
		"""Constructor to initialize a ZoneListener instance.
		
		This constructor initializes a ZoneListener instance and sets
		its initial attributes based on arguments.
		
		Arguments
		 
		  self -- this instance
		  
		  bindto -- [SOCKADDR] bind to this address
		  
		  services -- [HASH;STRING_zone,STRING_zone;STRING_service] a mapping between zone names and services

		  transparent -- [BOOLEAN] TRUE if this is a listener of a 
                                 transparent service, specifying this is
                                 not mandatory but performs additional checks
                                 
                  backlog -- [INTEGER] backlog value to pass to listen()

		  follow_parent -- [BOOLEAN] If set child zones inherit service set.

		"""
		CSZoneDispatcher.__init__(self, ZD_PROTO_TCP, bindto, services, kw=kw)
