/***************************************************************************
 *
 * Copyright (c) 2000, 2001, 2002, 2003, 2004 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * Note that this permission is granted for only version 2 of the GPL.
 *
 * As an additional exemption you are allowed to compile & link against the
 * OpenSSL libraries as published by the OpenSSL project. See the file
 * COPYING for details.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: pysockaddr.h,v 1.4 2002/04/05 14:55:54 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_PYSOCKADDR_H_INCLUDED
#define ZORP_PYSOCKADDR_H_INCLUDED

#include <zorp/zpython.h>
#include <zorp/sockaddr.h>

/*+

  ZorpSockAddr is the Python interface to ZSockAddr

  +*/
typedef struct _ZorpSockAddr
{
  PyObject_HEAD
  ZSockAddr *sa;
} ZorpSockAddr;

extern PyTypeObject z_py_zorp_sockaddr_type;

PyObject *z_py_zorp_sockaddr_new(ZSockAddr *sa);
#define z_py_zorp_sockaddr_check(ob) ((ob)->ob_type == &z_py_zorp_sockaddr_type)

void z_py_zorp_sockaddr_init(void);

#endif

