/***************************************************************************
 *
 * Copyright (c) 2000, 2001, 2002, 2003, 2004 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * Note that this permission is granted for only version 2 of the GPL.
 *
 * As an additional exemption you are allowed to compile & link against the
 * OpenSSL libraries as published by the OpenSSL project. See the file
 * COPYING for details.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: szig.h,v 1.6 2003/09/24 09:56:42 bazsi Exp $
 *
 ***************************************************************************/

#ifndef ZORP_SZIG_H_INCLUDED
#define ZORP_SZIG_H_INCLUDED

#include <zorp/zorp.h>

#define Z_SZIG_THREAD_START 0
#define Z_SZIG_THREAD_STOP  1
#define Z_SZIG_MIN1_TICK    2
#define Z_SZIG_MIN5_TICK    3
#define Z_SZIG_MIN15_TICK   4
#define Z_SZIG_COUNTED_IP   5

#define Z_SZIG_MAX          5

#define Z_SZIG_TYPE_NOTINIT 0
#define Z_SZIG_TYPE_LONG    1
#define Z_SZIG_TYPE_TIME    2
#define Z_SZIG_TYPE_STRING  3

typedef gint ZSzigEvent;
typedef struct _ZSzigValue ZSzigValue;
typedef struct _ZSzigNode ZSzigNode;

struct _ZSzigValue
{
  gint type;
  union
  {
    glong long_value;
    GTimeVal time_value;
    GString *string_value;
  } u;
};

typedef void (*ZSzigEventHandler)(ZSzigNode *node, ZSzigEvent ev, ZSzigValue *param, gpointer user_data);

void z_szig_register_handler(ZSzigEvent ev, ZSzigEventHandler func, const gchar *node_name, gpointer user_data);
void z_szig_unregister_handler(ZSzigEvent ev, ZSzigEventHandler func);

void z_szig_event(ZSzigEvent ev, ZSzigValue *param);

void z_szig_init(const gchar *instance_name);

ZSzigValue *z_szig_value_new_long(glong val);
ZSzigValue *z_szig_value_new_time(GTimeVal *val);
ZSzigValue *z_szig_value_new_string(const gchar *val);
void z_szig_value_free(ZSzigValue *v);

#endif
