/***************************************************************************
 *
 * Copyright (c) 2000, 2001, 2002, 2003, 2004 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * Note that this permission is granted for only version 2 of the GPL.
 *
 * As an additional exemption you are allowed to compile & link against the
 * OpenSSL libraries as published by the OpenSSL project. See the file
 * COPYING for details.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: nullcode.c,v 1.1 2004/02/03 12:27:06 sasa Exp $
 *
 * Author  : SaSa
 * Auditor :
 * Last audited version:
 * Notes:
 *
 ***************************************************************************/

#include <zorp/proxy/code.h>
#include <zorp/zorp.h>
#include <zorp/log.h>

#include <string.h>

/*
 * Null (identical) coding
 *
 * Output is simply a copy of the input, no change is made.
 */

typedef struct _ZCodeNull
{
  ZCode super;
} ZCodeNull;

/**
 * z_code_null_decode:
 * @code: not used
 * @from: Input buffer
 * @fromlen: Input data length
 * @to: Output buffer
 * @tolen: Output data length
 *
 * Simply copies input to output. The 'algorithm' requires no persistent
 * context, so @code is not used at all.
 *
 * Returns:
 * TRUE on success
 */
static gboolean
z_code_null_decode(ZCode    *code G_GNUC_UNUSED,
                   const gchar *from,
                   guint     fromlen,
                   gchar    *to,
                   guint    *tolen)
{
  z_enter();
  
  if (*tolen < fromlen)
    {
      return FALSE;
    }

  memcpy(to, from, fromlen);
  
  *tolen = fromlen;
  
  z_leave();
  return TRUE;
}


/**
 * z_code_null_start:
 * @code: not used
 *
 * Null coding has no context, requires no initialisation -> dummy
 *
 * Returns:
 * TRUE
 */
static gboolean
z_code_null_start(ZCode *code G_GNUC_UNUSED)
{
  return TRUE;
}

/**
 * z_code_null_finish:
 * @code: not used
 * @to: not used
 * @tolen: Digest output size
 *
 * Null coding produces no digest output, so @tolen is set to 0
 *
 * Returns:
 * TRUE
 */
static gboolean
z_code_null_finish(ZCode *code G_GNUC_UNUSED,
                   gchar *to G_GNUC_UNUSED,
                   guint *tolen)
{
  *tolen = 0;
  return TRUE;
}

/**
 * z_code_null_new:
 *
 * Constructor
 *
 * Returns:
 * The new instance
 */
ZCode *
z_code_null_new(void)
{
  ZCodeNull *self = g_new0(ZCodeNull, 1);
  z_enter();
  self->super.type = Z_CODE_NULL;
  self->super.decode_start = z_code_null_start;
  self->super.decode = z_code_null_decode;
  self->super.decode_finish = z_code_null_finish;
  self->super.encode_start = z_code_null_start;
  self->super.encode = z_code_null_decode;
  self->super.encode_finish = z_code_null_finish;
  z_leave();
  return &self->super;
}
