############################################################################
##
## Copyright (c) 2000, 2001, 2002 BalaBit IT Ltd, Budapest, Hungary
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##
## $Id: Receiver.py,v 1.38 2004/02/06 12:46:45 bazsi Exp $
##
## Author  : Bazsi
## Auditor : 
## Last audited version: 
## Notes:
##
############################################################################

from Dispatch import *

class Receiver(Dispatcher):
	def __init__(self, bindto, service, **kw):
		"""Constructor to initialize a ZoneReceiver instance.
		
		This constructor initializes a ZoneReceiver instance and sets
		its initial attributes based on arguments.
		
		Arguments
		 
		  self        -- this instance

		  bindto      -- [SOCKADDR]

		  service     -- [STRING_service]

		  transparent -- [BOOLEAN]

		  threaded    -- [BOOLEAN] specifies whether to use a separate thread to start new proxies

                  mark_tproxy -- [BOOLEAN] whether all incoming connections
                                 will be matched by '-m tproxy'

		  session_limit     -- [INTEGER] specifies the maximum number of proxies permitted to start in a single poll loop
		"""
		Dispatcher.__init__(self, ZD_PROTO_UDP, bindto, service, kw=kw)

class ZoneReceiver(ZoneDispatcher):
	def __init__(self, bindto, services, **kw):
		"""Constructor to initialize a ZoneReceiver instance.
		
		This constructor initializes a ZoneReceiver instance and sets
		its initial attributes based on arguments.
		
		Arguments
		 
		  self -- this instance
		  
		  bindto -- [SOCKADDR] bind to this address
		  
		  services -- [HASH;STRING_zone;STRING_service] a mapping between zone names and services

		  transparent -- [BOOLEAN]

		  threaded -- [BOOLEAN] specifies whether to use a separate thread to start new proxies

                  mark_tproxy -- [BOOLEAN] whether all incoming connections
                                 will be matched by '-m tproxy'

		  session_limit     -- [INTEGER] specifies the maximum number of proxies permitted to start in a single poll loop

		"""
		ZoneDispatcher.__init__(self, ZD_PROTO_UDP, bindto, services, kw=kw)

class CSZoneReceiver(CSZoneDispatcher):
	"""Class to listen on the selected address, and start a service based on the client's and the original server zone.
	
	This class is similar to a simple Receiver, but instead of
	starting a fixed service, it chooses one based on the client
	and the destined server zone.
	
	It takes a mapping of services indexed by a client and the server
	zone name, with an exception of the '*' zone, which matches
	anything.

	NOTE: the server zone might change during proxy and NAT processing,
	therefore the server zone used here only matches the real
	destination if those phases leave the server address intact.
	"""
	
	def __init__(self, bindto, services, **kw):
		"""Constructor to initialize a ZoneReceiver instance.
		
		This constructor initializes a ZoneReceiver instance and sets
		its initial attributes based on arguments.
		
		Arguments
		 
		  self -- this instance
		  
		  bindto -- [SOCKADDR] bind to this address
		  
		  services -- [HASH;STRING_zone,STRING_zone;STRING_service] a mapping between zone names and services

		  transparent -- [BOOLEAN]

		  threaded -- [BOOLEAN] specifies whether to use a separate thread to start new proxies

                  mark_tproxy -- [BOOLEAN] whether all incoming connections
                                 will be matched by '-m tproxy'

		  session_limit     -- [INTEGER] specifies the maximum number of proxies permitted to start in a single poll loop

		"""
		CSZoneDispatcher.__init__(self, ZD_PROTO_UDP, bindto, services, kw)
