############################################################################
##
## Copyright (c) 2000, 2001, 2002 BalaBit IT Ltd, Budapest, Hungary
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##
## $Id$
##
## Author  : Bazsi
## Auditor : 
## Last audited version:
## Notes:
##
############################################################################

"""Module defining the resolver interface to be used to resolve names to IP addresses.

This module defines the AbstractResolver interface and various derived classes
to perform name lookups.
"""

from Zorp import *
from SockAddr import SockAddrInet, getHostByName

class AbstractResolver:
        def __init__(self):
                pass
                
        def resolve(self, host, port):
                raise NotImplementedError

class DNSResolver(AbstractResolver):
        def __init__(self, multi=FALSE):
                AbstractResolver.__init__(self)
                self.multi = multi
                
        def resolve(self, host, port):
                try:
			ip_list = getHostByName(host)
			if self.multi:
			        return map(lambda ip: SockAddrInet(ip, port), ip_list)
			else:
        			return SockAddrInet(ip_list[0], port)
		except IOError:
			## LOG ##
			# This message indicates that the given hostname
			# could not be resolved.  It could happen if the
			# hostname is invalid or nonexistent, or it if your
			# resolve setting are not well configured.  Check
			# your "/etc/resolv.conf"
			##
			log(None, CORE_ERROR, 3, "Error resolving hostname; host='%s'", (host,))
			return None
