############################################################################
##
## Copyright (c) 2000, 2001, 2002 BalaBit IT Ltd, Budapest, Hungary
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##
## $Id: Stream.py,v 1.13 2002/04/19 12:41:03 sasa Exp $
##
## Author  : Bazsi
## Auditor : kisza
## Last audited version: 1.4
## Notes:
##
############################################################################

"""Module exporting an interface to the Zorp.Stream component.

This module defines the Stream class, encapsulating a file descriptor and
related functions. 
"""

class Stream:
	"""Class encapsulating a file descriptor and related functions.
	
	This class encapsulates a data tunnel, represented by a UNIX 
	file descriptor. It's implemented and exported by the Zorp core.
	
	Attributes
	
	  none
	"""
	
	def __init__(self, fd, name):
		"""Constructor to initialize a stream.
		
		This constructor initializes a Stream instance setting its
		attributes according to arguments.
		
		Arguments
		
		  self -- this instance
		  
		  fd -- the fd to encapsulate
		  
		  name -- name to use in logs
		"""
		pass

	def read(self, count):
		"""Method reading up to count bytes from the stream.
		
		This method reads up to count bytes from the stream
		and returns it as a string.
		
		Arguments
		
		  self -- this instance
		  
		  count -- maximum number of bytes to read
		"""
		pass
		
	def write(self, buf):
		"""Method writing a buffer to the stream.
		
		This method writes the contents of the given buffer to
		the stream.
		
		Arguments
		
		  self -- this instance
		  
		  buf -- buffer to write
		"""
