############################################################################
##
## Copyright (c) 2000, 2001, 2002 BalaBit IT Ltd, Budapest, Hungary
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##
## $Id: Zorp.py,v 1.66 2004/08/03 08:55:48 bazsi Exp $
##
## Author  : Bazsi
## Auditor : kisza
## Last audited version: 1.8
## Notes:
##
############################################################################

"""Module defining global constants, and interface entry points to the Zorp core.

This module defines some global constants used by other Zorp components like
'TRUE' and 'FALSE', and interface entry points to the Zorp core.
"""

firewall_name = "zorp" # should be unique, proposed name format: zorp@domain
#settings = {}          # configuration is stored in this hash

import Globals
import new

CORE_SESSION = "core.session"
CORE_DEBUG = "core.debug"
CORE_ERROR = "core.error"
CORE_POLICY = "core.policy"
CORE_MESSAGE = "core.message"
CORE_AUTH = "core.auth"

# return values returned by event handlers
Z_UNSPEC	 = 0
Z_ACCEPT	 = 1
Z_DENY		 = 2
Z_REJECT	 = 3
Z_ABORT          = 4
Z_DROP		 = 5
Z_POLICY         = 6
Z_ERROR		 = 7

# dispatched protocols
ZD_PROTO_AUTO = 0
ZD_PROTO_TCP  = 1
ZD_PROTO_UDP  = 2
ZD_PROTO_TCP6 = 3
ZD_PROTO_UDP6 = 4

ZD_PROTO_NAME = (
   "AUTO",    # ZD_PROTO_AUTO
   "TCP",     # ZD_PROTO_TCP
   "UDP",     # ZD_PROTO_UDP
   "TCP6",    # ZD_PROTO_TCP6
   "UDP6",    # ZD_PROTO_UDP6
)

# port allocation values
Z_PORT_ANY = -1
Z_PORT_GROUP = -2
Z_PORT_EXACT = -3

# basic acl tags
Z_BACL_REQUIRED = 1
Z_BACL_SUFFICIENT = 2

# boolean values
FALSE = 0
TRUE = 1

# address families
AF_UNSPEC = 0
AF_INET6 = 10

from socket import AF_UNIX, AF_INET, SOCK_STREAM, SOCK_DGRAM

ZoneException = "Zone not found"
ServiceException = "Service"
DACException = "DAC policy violation"
MACException = "MAC policy violation"
AuthException = "Authentication or authorization failed"
LimitException = "Limit error"
InternalException = "Internal error occured"
UserException = "Incorrect, or unspecified parameter"
LicenseException = "Attempt to use unlicensed components"
MatcherException = "Matcher error"

def getKeywordArg(kw, ndx, default):
	if kw and kw.has_key(ndx):
		default = kw[ndx]
		del kw[ndx]
	return default

def addConfigContainer(root, cont):
	setattr(root, cont, new.module(cont))
	
def init(names):
	"""Default init() function provided by Zorp
	
	This function is a default init() calling the init function
	identified by name. This way several Zorp instances can easily
	use the same policy file.

	Arguments
	
	  name -- name of this instance
	"""
	import __main__
	global firewall_name
	try:
		fw_name = firewall_name
		for i in names:
			firewall_name = '%s@%s' % (i, fw_name)
			func = getattr(__main__, i)
			func()
		firewall_name = fw_name
		return TRUE
	except AttributeError:
		## LOG ##
		# This message indicates that the initialization function of
		# the given instance was not found in the policy file.
		##
		log(None, CORE_ERROR, 0, "Instance definition not found in policy; instance='%s'", (names,))


## NOLOG ##		
def log(sessionid, logclass, verbosity, msg, args=None):
	"""Entry point of Zorp logging subsystem.
	
	This function is implemented in C, and can be used to inject
	messages into Zorp logging subsystem.

	Arguments

          sessionid -- the id of the session we belong to

	  logclass -- hierarchical log class as described in zorp(8)
	  
	  verbosity -- verbosity of this message

	  msg -- message
	"""
	pass

class ZorpProxy:
	"""Builtin interface for proxies implemented in C.
	
	Builtin class for proxies implemented as an ExtensionClass in C
	
	This class should not be used directly, derive classes
	from Proxy.Proxy.
	  
	"""
	def __init__(self, name, session_id, client_stream):
		"""Initialize a low level proxy instance.

		This function is implemented in C, and is responsible
		of loading the needed proxy module from a shared object
		if it has not yet been loaded, and starting a new
		instance with parameters passed here.
		
		Arguments

		  self          -- this instance
		
		  name          -- proxy module name ('http', 'plug' etc.)
		  
		  session_id    -- session id to use in log messages
		  
		  client_stream -- client stream
		  
		"""
		pass
