CONFIG += qt
#CONFIG += qt debug

TEMPLATE = app
TARGET   = zyGrib

DEPENDPATH += .
INCLUDEPATH += GUI bzip2 zlib-1.2.3 proj-4.6.0/src
LIBS += -Lbzip2 -lbz2 -Lzlib-1.2.3 -lz -Lproj-4.6.0/src -lproj

win32 {
	LIBS += -lregex
}

win32 {
	DESTDIR = release
}
else {
	DESTDIR = ..
}

OBJECTS_DIR = objs
SOURCES_DIR = .
UI_DIR  = GUI
MOC_DIR = objs

QT += network xml

CODECFORTR = UTF-8
CODECFORSRC = UTF-8

TRANSLATIONS =  ../tr/zyGrib_en.ts \
				../tr/zyGrib_de.ts \
				../tr/zyGrib_it.ts \
				../tr/zyGrib_ru.ts \
				../tr/zyGrib_es.ts

!win32 {
	# conditional, because uic dont work in my cross compilator environment.
	# ui_*.h files are made under linux before windows compilation.
	
	FORMS += GUI/PositionEditorWidget.ui \
		 	 GUI/PoiEditorDialog.ui \
			 GUI/ColorEditorWidget.ui \
			 GUI/LineEditorWidget.ui \
			 GUI/TextStyleEditorWidget.ui \
			 GUI/GraphicsParamsDialog.ui \
			 GUI/MeteotableOptionsDialog.ui \
		 	 GUI/AngleConverterWidget.ui \
}

HEADERS += \
			 GUI/PositionEditorWidget.h \
			 GUI/ColorEditorWidget.h \
			 GUI/LineEditorWidget.h \
			 GUI/TextStyleEditorWidget.h \
		 	 GUI/AngleConverterWidget.h \
		 	 GUI/AngleConverterDialog.h \
           BoardToolBar.h \
           DialogGraphicsParams.h \
           DialogLoadGRIB.h \
           DialogLoadIAC.h \
           DialogProxy.h \
           DialogServerStatus.h \
           DialogUnits.h \
           FileLoaderGRIB.h \
           FileLoaderIAC.h \
           GshhsRangsReader.h \
           GshhsReader.h \
           GisReader.h \
           GribAnimator.h \
           GribPlot.h \
           GribPointInfo.h \
           GribReader.h \
           GribRecord.h \
           IacPlot.h \
           IacReader.h \
           IsoLine.h \
           LonLatGrid.h \
           MainWindow.h \
           MenuBar.h \
           MeteoTable.h \
           MeteotableOptionsDialog.h \
           Orthodromie.h \
           POI.h \
           POI_Editor.h \
           PositionEditor.h \
           Projection.h \
           sha1/sha1.h \
           MapDrawer.h \
           Settings.h \
           Terrain.h \
           Util.h \
           Version.h \
           zuFile.h

SOURCES += \
			 GUI/PositionEditorWidget.cpp \
			 GUI/ColorEditorWidget.cpp \
			 GUI/LineEditorWidget.cpp \
			 GUI/TextStyleEditorWidget.cpp \
		 	 GUI/AngleConverterWidget.cpp \
		 	 GUI/AngleConverterDialog.cpp \
           IacPlot.cpp \
           IacReader.cpp \
           IacReaderUtil.cpp \
           Projection.cpp \
           Projection_libproj.cpp \
           BoardToolBar.cpp \
           DialogGraphicsParams.cpp \
           DialogLoadGRIB.cpp \
           DialogLoadIAC.cpp \
           DialogProxy.cpp \
           DialogServerStatus.cpp \
           DialogUnits.cpp \
           FileLoaderGRIB.cpp \
           FileLoaderIAC.cpp \
           GshhsRangsReader.cpp \
           GshhsReader.cpp \
           GribAnimator.cpp \
           GisReader.cpp \
           GribPlot.cpp \
           GribPointInfo.cpp \
           GribReader.cpp \
           GribRecord.cpp \
           IsoLine.cpp \
           LonLatGrid.cpp \
           main.cpp \
           MainWindow.cpp \
           MenuBar.cpp \
           MeteoTable.cpp \
           MeteotableOptionsDialog.cpp \
           Orthodromie.cpp \
           POI.cpp \
           POI_Editor.cpp \
           PositionEditor.cpp \
           sha1/sha1.cpp \
           MapDrawer.cpp \
           Settings.cpp \
           Terrain.cpp \
           Util.cpp \
           zuFile.cpp


